@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creationTime FC service creation time.
 * @property description FC service description.
 * @property id FC service ID.
 * @property internetAccess Indicate whether the service can access to internet or not.
 * @property lastModificationTime FC service last modification time.
 * @property logConfig A list of one element containing information about the associated log store. It contains the following attributes:
 * @property name FC service name.
 * @property nasConfig A list of one element about the nas configuration.
 * @property role FC service role ARN.
 * @property vpcConfig A list of one element containing information about accessible VPC resources. It contains the following attributes:
 */
public data class GetServicesService(
    public val creationTime: String,
    public val description: String,
    public val id: String,
    public val internetAccess: Boolean,
    public val lastModificationTime: String,
    public val logConfig: GetServicesServiceLogConfig,
    public val name: String,
    public val nasConfig: GetServicesServiceNasConfig,
    public val role: String,
    public val vpcConfig: GetServicesServiceVpcConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetServicesService): GetServicesService = GetServicesService(
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            id = javaType.id(),
            internetAccess = javaType.internetAccess(),
            lastModificationTime = javaType.lastModificationTime(),
            logConfig = javaType.logConfig().let({ args0 ->
                com.pulumi.alicloud.fc.kotlin.outputs.GetServicesServiceLogConfig.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            nasConfig = javaType.nasConfig().let({ args0 ->
                com.pulumi.alicloud.fc.kotlin.outputs.GetServicesServiceNasConfig.Companion.toKotlin(args0)
            }),
            role = javaType.role(),
            vpcConfig = javaType.vpcConfig().let({ args0 ->
                com.pulumi.alicloud.fc.kotlin.outputs.GetServicesServiceVpcConfig.Companion.toKotlin(args0)
            }),
        )
    }
}
