@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property groupId The group id of the NAS file system.
 * @property mountPoints The mount points configuration, including following attributes:
 * @property userId The user id of the NAS file system.
 */
public data class GetServicesServiceNasConfig(
    public val groupId: Int,
    public val mountPoints: List<GetServicesServiceNasConfigMountPoint>,
    public val userId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetServicesServiceNasConfig): GetServicesServiceNasConfig = GetServicesServiceNasConfig(
            groupId = javaType.groupId(),
            mountPoints = javaType.mountPoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.GetServicesServiceNasConfigMountPoint.Companion.toKotlin(args0)
                })
            }),
            userId = javaType.userId(),
        )
    }
}
