@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupId Associated security group ID.
 * @property vpcId Associated VPC ID.
 * @property vswitchIds Associated vSwitch IDs.
 */
public data class GetServicesServiceVpcConfig(
    public val securityGroupId: String,
    public val vpcId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetServicesServiceVpcConfig): GetServicesServiceVpcConfig = GetServicesServiceVpcConfig(
            securityGroupId = javaType.securityGroupId(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
