@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTriggers.
 * @property functionName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of FC triggers ids.
 * @property nameRegex
 * @property names A list of FC triggers names.
 * @property outputFile
 * @property serviceName
 * @property triggers A list of FC triggers. Each element contains the following attributes:
 */
public data class GetTriggersResult(
    public val functionName: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val serviceName: String,
    public val triggers: List<GetTriggersTrigger>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetTriggersResult): GetTriggersResult = GetTriggersResult(
            functionName = javaType.functionName(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName(),
            triggers = javaType.triggers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.GetTriggersTrigger.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
