@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property config JSON-encoded trigger configuration. See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
 * @property creationTime FC trigger creation time.
 * @property id FC trigger ID.
 * @property invocationRole RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
 * @property lastModificationTime FC trigger last modification time.
 * @property name FC trigger name.
 * @property sourceArn Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
 * @property type Type of the trigger. Valid values: `oss`, `log`, `timer`, `http`, `mns_topic`, `cdn_events` and `eventbridge`.
 */
public data class GetTriggersTrigger(
    public val config: String,
    public val creationTime: String,
    public val id: String,
    public val invocationRole: String,
    public val lastModificationTime: String,
    public val name: String,
    public val sourceArn: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetTriggersTrigger): GetTriggersTrigger = GetTriggersTrigger(
            config = javaType.config(),
            creationTime = javaType.creationTime(),
            id = javaType.id(),
            invocationRole = javaType.invocationRole(),
            lastModificationTime = javaType.lastModificationTime(),
            name = javaType.name(),
            sourceArn = javaType.sourceArn(),
            type = javaType.type(),
        )
    }
}
