@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableInstanceMetrics Enable instance level metrics.
 * @property enableRequestMetrics Enable request level metrics.
 * @property logstore The log store name of Alicloud Simple Log Service.
 * @property project The project name of the Alicloud Simple Log Service.
 */
public data class ServiceLogConfig(
    public val enableInstanceMetrics: Boolean? = null,
    public val enableRequestMetrics: Boolean? = null,
    public val logstore: String,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.ServiceLogConfig): ServiceLogConfig = ServiceLogConfig(
            enableInstanceMetrics = javaType.enableInstanceMetrics().map({ args0 -> args0 }).orElse(null),
            enableRequestMetrics = javaType.enableRequestMetrics().map({ args0 -> args0 }).orElse(null),
            logstore = javaType.logstore(),
            project = javaType.project(),
        )
    }
}
