@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property groupId The group id of your NAS file system.
 * @property mountPoints Config the NAS mount points.See `mount_points` below.
 * @property userId The user id of your NAS file system.
 */
public data class ServiceNasConfig(
    public val groupId: Int,
    public val mountPoints: List<ServiceNasConfigMountPoint>,
    public val userId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.ServiceNasConfig): ServiceNasConfig = ServiceNasConfig(
            groupId = javaType.groupId(),
            mountPoints = javaType.mountPoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.ServiceNasConfigMountPoint.Companion.toKotlin(args0)
                })
            }),
            userId = javaType.userId(),
        )
    }
}
