@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mountDir The local address where to mount your remote NAS directory.
 * @property serverAddr The address of the remote NAS directory.
 */
public data class ServiceNasConfigMountPoint(
    public val mountDir: String,
    public val serverAddr: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.ServiceNasConfigMountPoint): ServiceNasConfigMountPoint = ServiceNasConfigMountPoint(
            mountDir = javaType.mountDir(),
            serverAddr = javaType.serverAddr(),
        )
    }
}
