@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupId A security group ID associated with the Function Compute Service.
 * @property vpcId A vpc ID associated with the Function Compute Service.
 * @property vswitchIds A list of vswitch IDs associated with the Function Compute Service.
 */
public data class ServiceVpcConfig(
    public val securityGroupId: String,
    public val vpcId: String? = null,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.ServiceVpcConfig): ServiceVpcConfig = ServiceVpcConfig(
            securityGroupId = javaType.securityGroupId(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
