@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ossBucketName The OSS bucket name of the function code package.
 * @property ossObjectName The OSS object name of the function code package.
 * @property zipFile Upload the base64 encoding of the code zip package directly in the request body.
 */
public data class V2FunctionCode(
    public val ossBucketName: String? = null,
    public val ossObjectName: String? = null,
    public val zipFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V2FunctionCode): V2FunctionCode =
            V2FunctionCode(
                ossBucketName = javaType.ossBucketName().map({ args0 -> args0 }).orElse(null),
                ossObjectName = javaType.ossObjectName().map({ args0 -> args0 }).orElse(null),
                zipFile = javaType.zipFile().map({ args0 -> args0 }).orElse(null),
            )
    }
}
