@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accelerationType Image acceleration type. The value Default is to enable acceleration and None is to disable acceleration.
 * @property args Container startup parameters.
 * @property command Container start command, equivalent to Docker ENTRYPOINT.
 * @property image Container Image address. Example value: registry-vpc.cn-hangzhou.aliyuncs.com/fc-demo/helloworld:v1beta1.
 * @property webServerMode Whether the image is run in Web Server mode. The value of true needs to implement the Web Server in the container image to listen to the port and process the request. The value of false needs to actively exit the process after the container runs, and the ExitCode needs to be 0. Default true.
 */
public data class V2FunctionCustomContainerConfig(
    public val accelerationType: String? = null,
    public val args: String? = null,
    public val command: String? = null,
    public val image: String? = null,
    public val webServerMode: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V2FunctionCustomContainerConfig): V2FunctionCustomContainerConfig = V2FunctionCustomContainerConfig(
            accelerationType = javaType.accelerationType().map({ args0 -> args0 }).orElse(null),
            args = javaType.args().map({ args0 -> args0 }).orElse(null),
            command = javaType.command().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            webServerMode = javaType.webServerMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
