@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsOptions DNS resolver configuration parameter list. See `dns_options` below.
 * @property nameServers List of IP addresses of DNS servers.
 * @property searches List of DNS search domains.
 */
public data class V2FunctionCustomDns(
    public val dnsOptions: List<V2FunctionCustomDnsDnsOption>? = null,
    public val nameServers: List<String>? = null,
    public val searches: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V2FunctionCustomDns): V2FunctionCustomDns = V2FunctionCustomDns(
            dnsOptions = javaType.dnsOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V2FunctionCustomDnsDnsOption.Companion.toKotlin(args0)
                })
            }),
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            searches = javaType.searches().map({ args0 -> args0 }),
        )
    }
}
