@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property failureThreshold The threshold for the number of health check failures. The system considers the check failed after the health check fails.
 * @property httpGetUrl Container custom health check URL address.
 * @property initialDelaySeconds Delay from container startup to initiation of health check.
 * @property periodSeconds Health check cycle.
 * @property successThreshold The threshold for the number of successful health checks. After the health check is reached, the system considers the check successful.
 * @property timeoutSeconds Health check timeout.
 */
public data class V2FunctionCustomHealthCheckConfig(
    public val failureThreshold: Int? = null,
    public val httpGetUrl: String? = null,
    public val initialDelaySeconds: Int? = null,
    public val periodSeconds: Int? = null,
    public val successThreshold: Int? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V2FunctionCustomHealthCheckConfig): V2FunctionCustomHealthCheckConfig = V2FunctionCustomHealthCheckConfig(
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            httpGetUrl = javaType.httpGetUrl().map({ args0 -> args0 }).orElse(null),
            initialDelaySeconds = javaType.initialDelaySeconds().map({ args0 -> args0 }).orElse(null),
            periodSeconds = javaType.periodSeconds().map({ args0 -> args0 }).orElse(null),
            successThreshold = javaType.successThreshold().map({ args0 -> args0 }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
