@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args Parameters received by the start entry command.
 * @property commands List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
 */
public data class V2FunctionCustomRuntimeConfig(
    public val args: List<String>? = null,
    public val commands: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V2FunctionCustomRuntimeConfig): V2FunctionCustomRuntimeConfig = V2FunctionCustomRuntimeConfig(
            args = javaType.args().map({ args0 -> args0 }),
            commands = javaType.commands().map({ args0 -> args0 }),
        )
    }
}
