@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certName Certificate Name.
 * @property certificate PEM format certificate.
 * @property privateKey Private Key in PEM format.
 */
public data class V3CustomDomainCertConfig(
    public val certName: String? = null,
    public val certificate: String? = null,
    public val privateKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3CustomDomainCertConfig): V3CustomDomainCertConfig = V3CustomDomainCertConfig(
            certName = javaType.certName().map({ args0 -> args0 }).orElse(null),
            certificate = javaType.certificate().map({ args0 -> args0 }).orElse(null),
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
