@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property functionName Function name.
 * @property methods List of supported HTTP methods.
 * @property path Route matching rule.
 * @property qualifier Version or Alias.
 * @property rewriteConfig Override Configuration. See `rewrite_config` below.
 */
public data class V3CustomDomainRouteConfigRoute(
    public val functionName: String? = null,
    public val methods: List<String>? = null,
    public val path: String? = null,
    public val qualifier: String? = null,
    public val rewriteConfig: V3CustomDomainRouteConfigRouteRewriteConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3CustomDomainRouteConfigRoute): V3CustomDomainRouteConfigRoute = V3CustomDomainRouteConfigRoute(
            functionName = javaType.functionName().map({ args0 -> args0 }).orElse(null),
            methods = javaType.methods().map({ args0 -> args0 }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            rewriteConfig = javaType.rewriteConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3CustomDomainRouteConfigRouteRewriteConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
