@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property equalRules Exact Match Rule List. See `equal_rules` below.
 * @property regexRules Regular match rule list. See `regex_rules` below.
 * @property wildcardRules List of wildcard matching rules. See `wildcard_rules` below.
 */
public data class V3CustomDomainRouteConfigRouteRewriteConfig(
    public val equalRules: List<V3CustomDomainRouteConfigRouteRewriteConfigEqualRule>? = null,
    public val regexRules: List<V3CustomDomainRouteConfigRouteRewriteConfigRegexRule>? = null,
    public val wildcardRules: List<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRule>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3CustomDomainRouteConfigRouteRewriteConfig): V3CustomDomainRouteConfigRouteRewriteConfig = V3CustomDomainRouteConfigRouteRewriteConfig(
            equalRules = javaType.equalRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3CustomDomainRouteConfigRouteRewriteConfigEqualRule.Companion.toKotlin(args0)
                })
            }),
            regexRules = javaType.regexRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3CustomDomainRouteConfigRouteRewriteConfigRegexRule.Companion.toKotlin(args0)
                })
            }),
            wildcardRules = javaType.wildcardRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3CustomDomainRouteConfigRouteRewriteConfigWildcardRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
