@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cipherSuites List of TLS cipher suites.
 * @property maxVersion The maximum version of TLS. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
 * @property minVersion TLS minimum version number. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
 */
public data class V3CustomDomainTlsConfig(
    public val cipherSuites: List<String>? = null,
    public val maxVersion: String? = null,
    public val minVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3CustomDomainTlsConfig): V3CustomDomainTlsConfig = V3CustomDomainTlsConfig(
            cipherSuites = javaType.cipherSuites().map({ args0 -> args0 }),
            maxVersion = javaType.maxVersion().map({ args0 -> args0 }).orElse(null),
            minVersion = javaType.minVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
