@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property checksum The CRC-64 value of the function code package.
 * @property ossBucketName The name of the OSS Bucket that stores the function code ZIP package.
 * @property ossObjectName The name of the OSS Object that stores the function code ZIP package.
 * @property zipFile The Base 64 encoding of the function code ZIP package.
 */
public data class V3FunctionCode(
    public val checksum: String? = null,
    public val ossBucketName: String? = null,
    public val ossObjectName: String? = null,
    public val zipFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionCode): V3FunctionCode =
            V3FunctionCode(
                checksum = javaType.checksum().map({ args0 -> args0 }).orElse(null),
                ossBucketName = javaType.ossBucketName().map({ args0 -> args0 }).orElse(null),
                ossObjectName = javaType.ossObjectName().map({ args0 -> args0 }).orElse(null),
                zipFile = javaType.zipFile().map({ args0 -> args0 }).orElse(null),
            )
    }
}
