@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accelerationInfo (Deprecated since v1.228.0) - Image Acceleration Information (Obsolete).
 * @property accelerationType Whether to enable Image acceleration. Default: The Default value, indicating that image acceleration is enabled. None: indicates that image acceleration is disabled. (Obsolete).
 * @property acrInstanceId ACR Enterprise version Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete).
 * @property commands Container startup parameters.
 * @property entrypoints Container start command.
 * @property healthCheckConfig Function custom health check configuration. See `health_check_config` below.
 * @property image The container Image address.
 * @property port The listening port of the HTTP Server when the custom container runs.
 * @property resolvedImageUri The actual digest version of the deployed Image. The code version specified by this digest is used when the function starts.
 */
public data class V3FunctionCustomContainerConfig(
    @Deprecated(
        message = """
  Field 'acceleration_info' has been deprecated from provider version 1.228.0. Image Acceleration
      Information (Obsolete)
  """,
    )
    public val accelerationInfo: V3FunctionCustomContainerConfigAccelerationInfo? = null,
    @Deprecated(
        message = """
  Field 'acceleration_type' has been deprecated from provider version 1.228.0. Whether to enable
      Image acceleration. Default: The Default value, indicating that image acceleration is enabled.
      None: indicates that image acceleration is disabled. (Obsolete)
  """,
    )
    public val accelerationType: String? = null,
    @Deprecated(
        message = """
  Field 'acr_instance_id' has been deprecated from provider version 1.228.0. ACR Enterprise version
      Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete)
  """,
    )
    public val acrInstanceId: String? = null,
    public val commands: List<String>? = null,
    public val entrypoints: List<String>? = null,
    public val healthCheckConfig: V3FunctionCustomContainerConfigHealthCheckConfig? = null,
    public val image: String? = null,
    public val port: Int? = null,
    public val resolvedImageUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionCustomContainerConfig): V3FunctionCustomContainerConfig = V3FunctionCustomContainerConfig(
            accelerationInfo = javaType.accelerationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomContainerConfigAccelerationInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            accelerationType = javaType.accelerationType().map({ args0 -> args0 }).orElse(null),
            acrInstanceId = javaType.acrInstanceId().map({ args0 -> args0 }).orElse(null),
            commands = javaType.commands().map({ args0 -> args0 }),
            entrypoints = javaType.entrypoints().map({ args0 -> args0 }),
            healthCheckConfig = javaType.healthCheckConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomContainerConfigHealthCheckConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            resolvedImageUri = javaType.resolvedImageUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
