@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsOptions List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
 * @property nameServers IP Address List of DNS servers.
 * @property searches DNS search domain list.
 */
public data class V3FunctionCustomDns(
    public val dnsOptions: List<V3FunctionCustomDnsDnsOption>? = null,
    public val nameServers: List<String>? = null,
    public val searches: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionCustomDns): V3FunctionCustomDns = V3FunctionCustomDns(
            dnsOptions = javaType.dnsOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomDnsDnsOption.Companion.toKotlin(args0)
                })
            }),
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            searches = javaType.searches().map({ args0 -> args0 }),
        )
    }
}
