@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args Instance startup parameters.
 * @property commands Instance start command.
 * @property healthCheckConfig Function custom health check configuration. See `health_check_config` below.
 * @property port The listening port of the HTTP Server.
 */
public data class V3FunctionCustomRuntimeConfig(
    public val args: List<String>? = null,
    public val commands: List<String>? = null,
    public val healthCheckConfig: V3FunctionCustomRuntimeConfigHealthCheckConfig? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionCustomRuntimeConfig): V3FunctionCustomRuntimeConfig = V3FunctionCustomRuntimeConfig(
            args = javaType.args().map({ args0 -> args0 }),
            commands = javaType.commands().map({ args0 -> args0 }),
            healthCheckConfig = javaType.healthCheckConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionCustomRuntimeConfigHealthCheckConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
