@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property gpuMemorySize GPU memory specification, unit: MB, multiple of 1024MB.
 * @property gpuType GPU card architecture.
 * - fc.gpu.tesla.1 indicates the type of the Tesla Architecture Series card of the GPU instance (the same as the NVIDIA T4 card type).
 * - fc.gpu.ampere.1 indicates the GPU instance type of Ampere Architecture Series card (same as NVIDIA A10 card type).
 * - fc.gpu.ada.1 Indicates the GPU instance Ada Lovelace architecture family card type.
 */
public data class V3FunctionGpuConfig(
    public val gpuMemorySize: Int? = null,
    public val gpuType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionGpuConfig): V3FunctionGpuConfig = V3FunctionGpuConfig(
            gpuMemorySize = javaType.gpuMemorySize().map({ args0 -> args0 }).orElse(null),
            gpuType = javaType.gpuType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
