@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableInstanceMetrics After this feature is enabled, you can view core metrics such as instance-level CPU usage, memory usage, instance network status, and the number of requests within an instance. false: The default value, which means that instance-level metrics are turned off. true: indicates that instance-level metrics are enabled.
 * @property enableRequestMetrics After this function is enabled, you can view the time and memory consumed by a call to all functions under this service. false: indicates that request-level metrics are turned off. true: The default value, indicating that request-level metrics are enabled.
 * @property logBeginRule Log Line First Matching Rules.
 * @property logstore The Logstore name of log service.
 * @property project The name of the log service Project.
 */
public data class V3FunctionLogConfig(
    public val enableInstanceMetrics: Boolean? = null,
    public val enableRequestMetrics: Boolean? = null,
    public val logBeginRule: String? = null,
    public val logstore: String? = null,
    public val project: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionLogConfig): V3FunctionLogConfig = V3FunctionLogConfig(
            enableInstanceMetrics = javaType.enableInstanceMetrics().map({ args0 -> args0 }).orElse(null),
            enableRequestMetrics = javaType.enableRequestMetrics().map({ args0 -> args0 }).orElse(null),
            logBeginRule = javaType.logBeginRule().map({ args0 -> args0 }).orElse(null),
            logstore = javaType.logstore().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
        )
    }
}
