@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property groupId Group ID.
 * @property mountPoints Mount point list. See `mount_points` below.
 * @property userId Account ID.
 */
public data class V3FunctionNasConfig(
    public val groupId: Int? = null,
    public val mountPoints: List<V3FunctionNasConfigMountPoint>? = null,
    public val userId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionNasConfig): V3FunctionNasConfig = V3FunctionNasConfig(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            mountPoints = javaType.mountPoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.V3FunctionNasConfigMountPoint.Companion.toKotlin(args0)
                })
            }),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
