@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableTls Use transport encryption to mount. Note: only general-purpose NAS supports transmission encryption.
 * @property mountDir
 * @property serverAddr NAS server address.
 */
public data class V3FunctionNasConfigMountPoint(
    public val enableTls: Boolean? = null,
    public val mountDir: String? = null,
    public val serverAddr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionNasConfigMountPoint): V3FunctionNasConfigMountPoint = V3FunctionNasConfigMountPoint(
            enableTls = javaType.enableTls().map({ args0 -> args0 }).orElse(null),
            mountDir = javaType.mountDir().map({ args0 -> args0 }).orElse(null),
            serverAddr = javaType.serverAddr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
