@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName OSS Bucket name.
 * @property bucketPath Path of the mounted OSS Bucket.
 * @property endpoint OSS access endpoint.
 * @property mountDir
 * @property readOnly Read-only.
 */
public data class V3FunctionOssMountConfigMountPoint(
    public val bucketName: String? = null,
    public val bucketPath: String? = null,
    public val endpoint: String? = null,
    public val mountDir: String? = null,
    public val readOnly: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionOssMountConfigMountPoint): V3FunctionOssMountConfigMountPoint = V3FunctionOssMountConfigMountPoint(
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            bucketPath = javaType.bucketPath().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            mountDir = javaType.mountDir().map({ args0 -> args0 }).orElse(null),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
