@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupId Security group ID.
 * @property vpcId VPC network ID.
 * @property vswitchIds Switch List.
 */
public data class V3FunctionVpcConfig(
    public val securityGroupId: String? = null,
    public val vpcId: String? = null,
    public val vswitchIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.V3FunctionVpcConfig): V3FunctionVpcConfig = V3FunctionVpcConfig(
            securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
