@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Flow].
 */
@PulumiTagMarker
public class FlowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowArgs = FlowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowArgsBuilder.() -> Unit) {
        val builder = FlowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Flow {
        val builtJavaResource = com.pulumi.alicloud.fnf.Flow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Flow(builtJavaResource)
    }
}

/**
 * Provides a Serverless Workflow Flow resource.
 * For information about Serverless Workflow Flow and how to use it, see [What is Flow](https://www.alibabacloud.com/help/en/doc-detail/123079.htm).
 * > **NOTE:** Available since v1.105.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ram.Role("default", {
 *     name: "tf-example-fnfflow",
 *     document: `  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `,
 * });
 * const example = new alicloud.fnf.Flow("example", {
 *     definition: `  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `,
 *     roleArn: _default.arn,
 *     description: "Test for terraform fnf_flow.",
 *     name: "tf-example-flow",
 *     type: "FDL",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ram.Role("default",
 *     name="tf-example-fnfflow",
 *     document="""  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * """)
 * example = alicloud.fnf.Flow("example",
 *     definition="""  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * """,
 *     role_arn=default.arn,
 *     description="Test for terraform fnf_flow.",
 *     name="tf-example-flow",
 *     type="FDL")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ram.Role("default", new()
 *     {
 *         Name = "tf-example-fnfflow",
 *         Document = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": ""sts:AssumeRole"",
 *         ""Effect"": ""Allow"",
 *         ""Principal"": {
 *           ""Service"": [
 *             ""fnf.aliyuncs.com""
 *           ]
 *         }
 *       }
 *     ],
 *     ""Version"": ""1""
 *   }
 * ",
 *     });
 *     var example = new AliCloud.FNF.Flow("example", new()
 *     {
 *         Definition = @"  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * ",
 *         RoleArn = @default.Arn,
 *         Description = "Test for terraform fnf_flow.",
 *         Name = "tf-example-flow",
 *         Type = "FDL",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewRole(ctx, "default", &ram.RoleArgs{
 * 			Name: pulumi.String("tf-example-fnfflow"),
 * 			Document: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fnf.NewFlow(ctx, "example", &fnf.FlowArgs{
 * 			Definition: pulumi.String(`  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `),
 * 			RoleArn:     _default.Arn,
 * 			Description: pulumi.String("Test for terraform fnf_flow."),
 * 			Name:        pulumi.String("tf-example-flow"),
 * 			Type:        pulumi.String("FDL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.alicloud.fnf.Flow;
 * import com.pulumi.alicloud.fnf.FlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Role("default", RoleArgs.builder()
 *             .name("tf-example-fnfflow")
 *             .document("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 *             """)
 *             .build());
 *         var example = new Flow("example", FlowArgs.builder()
 *             .definition("""
 *   version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 *             """)
 *             .roleArn(default_.arn())
 *             .description("Test for terraform fnf_flow.")
 *             .name("tf-example-flow")
 *             .type("FDL")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ram:Role
 *     properties:
 *       name: tf-example-fnfflow
 *       document: |2
 *           {
 *             "Statement": [
 *               {
 *                 "Action": "sts:AssumeRole",
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                   "Service": [
 *                     "fnf.aliyuncs.com"
 *                   ]
 *                 }
 *               }
 *             ],
 *             "Version": "1"
 *           }
 *   example:
 *     type: alicloud:fnf:Flow
 *     properties:
 *       definition: |2
 *           version: v1beta1
 *           type: flow
 *           steps:
 *             - type: pass
 *               name: helloworld
 *       roleArn: ${default.arn}
 *       description: Test for terraform fnf_flow.
 *       name: tf-example-flow
 *       type: FDL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless Workflow Flow can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fnf/flow:Flow example <name>
 * ```
 */
public class Flow internal constructor(
    override val javaResource: com.pulumi.alicloud.fnf.Flow,
) : KotlinCustomResource(javaResource, FlowMapper) {
    /**
     * The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
     */
    public val definition: Output<String>
        get() = javaResource.definition().applyValue({ args0 -> args0 })

    /**
     * The description of the flow.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The unique ID of the flow.
     */
    public val flowId: Output<String>
        get() = javaResource.flowId().applyValue({ args0 -> args0 })

    /**
     * The time when the flow was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The name of the flow. The name must be unique in an Alibaba Cloud account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the flow. Valid values are `FDL` or `DEFAULT`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FlowMapper : ResourceMapper<Flow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fnf.Flow::class == javaResource::class

    override fun map(javaResource: Resource): Flow = Flow(
        javaResource as
            com.pulumi.alicloud.fnf.Flow,
    )
}

/**
 * @see [Flow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Flow].
 */
public suspend fun flow(name: String, block: suspend FlowResourceBuilder.() -> Unit): Flow {
    val builder = FlowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Flow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flow(name: String): Flow {
    val builder = FlowResourceBuilder()
    builder.name(name)
    return builder.build()
}
