@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin

import com.pulumi.alicloud.fnf.FlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Serverless Workflow Flow resource.
 * For information about Serverless Workflow Flow and how to use it, see [What is Flow](https://www.alibabacloud.com/help/en/doc-detail/123079.htm).
 * > **NOTE:** Available since v1.105.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ram.Role("default", {
 *     name: "tf-example-fnfflow",
 *     document: `  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `,
 * });
 * const example = new alicloud.fnf.Flow("example", {
 *     definition: `  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `,
 *     roleArn: _default.arn,
 *     description: "Test for terraform fnf_flow.",
 *     name: "tf-example-flow",
 *     type: "FDL",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ram.Role("default",
 *     name="tf-example-fnfflow",
 *     document="""  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * """)
 * example = alicloud.fnf.Flow("example",
 *     definition="""  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * """,
 *     role_arn=default.arn,
 *     description="Test for terraform fnf_flow.",
 *     name="tf-example-flow",
 *     type="FDL")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ram.Role("default", new()
 *     {
 *         Name = "tf-example-fnfflow",
 *         Document = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": ""sts:AssumeRole"",
 *         ""Effect"": ""Allow"",
 *         ""Principal"": {
 *           ""Service"": [
 *             ""fnf.aliyuncs.com""
 *           ]
 *         }
 *       }
 *     ],
 *     ""Version"": ""1""
 *   }
 * ",
 *     });
 *     var example = new AliCloud.FNF.Flow("example", new()
 *     {
 *         Definition = @"  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * ",
 *         RoleArn = @default.Arn,
 *         Description = "Test for terraform fnf_flow.",
 *         Name = "tf-example-flow",
 *         Type = "FDL",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewRole(ctx, "default", &ram.RoleArgs{
 * 			Name: pulumi.String("tf-example-fnfflow"),
 * 			Document: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fnf.NewFlow(ctx, "example", &fnf.FlowArgs{
 * 			Definition: pulumi.String(`  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `),
 * 			RoleArn:     _default.Arn,
 * 			Description: pulumi.String("Test for terraform fnf_flow."),
 * 			Name:        pulumi.String("tf-example-flow"),
 * 			Type:        pulumi.String("FDL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.alicloud.fnf.Flow;
 * import com.pulumi.alicloud.fnf.FlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Role("default", RoleArgs.builder()
 *             .name("tf-example-fnfflow")
 *             .document("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "fnf.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 *             """)
 *             .build());
 *         var example = new Flow("example", FlowArgs.builder()
 *             .definition("""
 *   version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 *             """)
 *             .roleArn(default_.arn())
 *             .description("Test for terraform fnf_flow.")
 *             .name("tf-example-flow")
 *             .type("FDL")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ram:Role
 *     properties:
 *       name: tf-example-fnfflow
 *       document: |2
 *           {
 *             "Statement": [
 *               {
 *                 "Action": "sts:AssumeRole",
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                   "Service": [
 *                     "fnf.aliyuncs.com"
 *                   ]
 *                 }
 *               }
 *             ],
 *             "Version": "1"
 *           }
 *   example:
 *     type: alicloud:fnf:Flow
 *     properties:
 *       definition: |2
 *           version: v1beta1
 *           type: flow
 *           steps:
 *             - type: pass
 *               name: helloworld
 *       roleArn: ${default.arn}
 *       description: Test for terraform fnf_flow.
 *       name: tf-example-flow
 *       type: FDL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless Workflow Flow can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fnf/flow:Flow example <name>
 * ```
 * @property definition The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
 * @property description The description of the flow.
 * @property name The name of the flow. The name must be unique in an Alibaba Cloud account.
 * @property roleArn The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
 * @property type The type of the flow. Valid values are `FDL` or `DEFAULT`.
 */
public data class FlowArgs(
    public val definition: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fnf.FlowArgs> {
    override fun toJava(): com.pulumi.alicloud.fnf.FlowArgs =
        com.pulumi.alicloud.fnf.FlowArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowArgs].
 */
@PulumiTagMarker
public class FlowArgsBuilder internal constructor() {
    private var definition: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
     */
    @JvmName("gmynudpavbvkeanl")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value The description of the flow.
     */
    @JvmName("qlmuicbdukvgwlwj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the flow. The name must be unique in an Alibaba Cloud account.
     */
    @JvmName("mobwxkociwqbqgmy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
     */
    @JvmName("iyunuxdkdpulhfqt")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The type of the flow. Valid values are `FDL` or `DEFAULT`.
     */
    @JvmName("ohlstkoajbcpkpfo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
     */
    @JvmName("eqosbxhcflsacdeu")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value The description of the flow.
     */
    @JvmName("qkbylnuqeiwffrer")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the flow. The name must be unique in an Alibaba Cloud account.
     */
    @JvmName("yweokdoqagaxucip")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
     */
    @JvmName("fhgpjooaivsixgxs")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The type of the flow. Valid values are `FDL` or `DEFAULT`.
     */
    @JvmName("vqlkaaqtwleoymiy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FlowArgs = FlowArgs(
        definition = definition,
        description = description,
        name = name,
        roleArn = roleArn,
        type = type,
    )
}
