@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin

import com.pulumi.alicloud.fnf.FnfFunctions.getExecutionsPlain
import com.pulumi.alicloud.fnf.FnfFunctions.getFlowsPlain
import com.pulumi.alicloud.fnf.FnfFunctions.getSchedulesPlain
import com.pulumi.alicloud.fnf.FnfFunctions.getServicePlain
import com.pulumi.alicloud.fnf.kotlin.inputs.GetExecutionsPlainArgs
import com.pulumi.alicloud.fnf.kotlin.inputs.GetExecutionsPlainArgsBuilder
import com.pulumi.alicloud.fnf.kotlin.inputs.GetFlowsPlainArgs
import com.pulumi.alicloud.fnf.kotlin.inputs.GetFlowsPlainArgsBuilder
import com.pulumi.alicloud.fnf.kotlin.inputs.GetSchedulesPlainArgs
import com.pulumi.alicloud.fnf.kotlin.inputs.GetSchedulesPlainArgsBuilder
import com.pulumi.alicloud.fnf.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.fnf.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.fnf.kotlin.outputs.GetExecutionsResult
import com.pulumi.alicloud.fnf.kotlin.outputs.GetFlowsResult
import com.pulumi.alicloud.fnf.kotlin.outputs.GetSchedulesResult
import com.pulumi.alicloud.fnf.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.fnf.kotlin.outputs.GetExecutionsResult.Companion.toKotlin as getExecutionsResultToKotlin
import com.pulumi.alicloud.fnf.kotlin.outputs.GetFlowsResult.Companion.toKotlin as getFlowsResultToKotlin
import com.pulumi.alicloud.fnf.kotlin.outputs.GetSchedulesResult.Companion.toKotlin as getSchedulesResultToKotlin
import com.pulumi.alicloud.fnf.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object FnfFunctions {
    /**
     * This data source provides the FnF Executions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.149.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.fnf.getExecutions({
     *     flowName: "example_value",
     *     ids: [
     *         "my-Execution-1",
     *         "my-Execution-2",
     *     ],
     * });
     * export const fnfExecutionId1 = idsAlicloudFnFExecutions.executions[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.fnf.get_executions(flow_name="example_value",
     *     ids=[
     *         "my-Execution-1",
     *         "my-Execution-2",
     *     ])
     * pulumi.export("fnfExecutionId1", ids_alicloud_fn_f_executions["executions"][0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.FNF.GetExecutions.Invoke(new()
     *     {
     *         FlowName = "example_value",
     *         Ids = new[]
     *         {
     *             "my-Execution-1",
     *             "my-Execution-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["fnfExecutionId1"] = idsAlicloudFnFExecutions&#46;Executions[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := fnf.GetExecutions(ctx, &fnf.GetExecutionsArgs{
     * 			FlowName: "example_value",
     * 			Ids: []string{
     * 				"my-Execution-1",
     * 				"my-Execution-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("fnfExecutionId1", idsAlicloudFnFExecutions.Executions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fnf.FnfFunctions;
     * import com.pulumi.alicloud.fnf.inputs.GetExecutionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = FnfFunctions.getExecutions(GetExecutionsArgs.builder()
     *             .flowName("example_value")
     *             .ids(
     *                 "my-Execution-1",
     *                 "my-Execution-2")
     *             .build());
     *         ctx.export("fnfExecutionId1", idsAlicloudFnFExecutions.executions()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:fnf:getExecutions
     *       Arguments:
     *         flowName: example_value
     *         ids:
     *           - my-Execution-1
     *           - my-Execution-2
     * outputs:
     *   fnfExecutionId1: ${idsAlicloudFnFExecutions.executions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExecutions.
     * @return A collection of values returned by getExecutions.
     */
    public suspend fun getExecutions(argument: GetExecutionsPlainArgs): GetExecutionsResult =
        getExecutionsResultToKotlin(getExecutionsPlain(argument.toJava()).await())

    /**
     * @see [getExecutions].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param flowName The name of the flow.
     * @param ids A list of Execution IDs. The value formats as `<flow_name>:<execution_name>`.
     * @param nameRegex A regex string to filter results by Execution name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Running`, `Stopped`, `Succeeded`, `Failed`, `TimedOut`.
     * @return A collection of values returned by getExecutions.
     */
    public suspend fun getExecutions(
        enableDetails: Boolean? = null,
        flowName: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetExecutionsResult {
        val argument = GetExecutionsPlainArgs(
            enableDetails = enableDetails,
            flowName = flowName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getExecutionsResultToKotlin(getExecutionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getExecutions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fnf&#46;kotlin&#46;inputs&#46;GetExecutionsPlainArgs].
     * @return A collection of values returned by getExecutions.
     */
    public suspend fun getExecutions(argument: suspend GetExecutionsPlainArgsBuilder.() -> Unit): GetExecutionsResult {
        val builder = GetExecutionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExecutionsResultToKotlin(getExecutionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Fnf Flows of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.105.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.fnf.getFlows({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstFnfFlowId = example.then(example => example.flows?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.fnf.get_flows(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstFnfFlowId", example.flows[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.FNF.GetFlows.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFnfFlowId"] = example&#46;Apply(getFlowsResult => getFlowsResult&#46;Flows[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := fnf.GetFlows(ctx, &fnf.GetFlowsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFnfFlowId", example.Flows[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fnf.FnfFunctions;
     * import com.pulumi.alicloud.fnf.inputs.GetFlowsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FnfFunctions.getFlows(GetFlowsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstFnfFlowId", example.applyValue(getFlowsResult -> getFlowsResult.flows()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:fnf:getFlows
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstFnfFlowId: ${example.flows[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFlows.
     * @return A collection of values returned by getFlows.
     */
    public suspend fun getFlows(argument: GetFlowsPlainArgs): GetFlowsResult =
        getFlowsResultToKotlin(getFlowsPlain(argument.toJava()).await())

    /**
     * @see [getFlows].
     * @param ids A list of Flow IDs.
     * @param limit The number of resource queries.
     * @param nameRegex A regex string to filter results by Flow name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getFlows.
     */
    public suspend fun getFlows(
        ids: List<String>? = null,
        limit: Int? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetFlowsResult {
        val argument = GetFlowsPlainArgs(
            ids = ids,
            limit = limit,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getFlowsResultToKotlin(getFlowsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFlows].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fnf&#46;kotlin&#46;inputs&#46;GetFlowsPlainArgs].
     * @return A collection of values returned by getFlows.
     */
    public suspend fun getFlows(argument: suspend GetFlowsPlainArgsBuilder.() -> Unit): GetFlowsResult {
        val builder = GetFlowsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFlowsResultToKotlin(getFlowsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Fnf Schedules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.105.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.fnf.getSchedules({
     *     flowName: "example_value",
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstFnfScheduleId = example.then(example => example.schedules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.fnf.get_schedules(flow_name="example_value",
     *     ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstFnfScheduleId", example.schedules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.FNF.GetSchedules.Invoke(new()
     *     {
     *         FlowName = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFnfScheduleId"] = example&#46;Apply(getSchedulesResult => getSchedulesResult&#46;Schedules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := fnf.GetSchedules(ctx, &fnf.GetSchedulesArgs{
     * 			FlowName: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFnfScheduleId", example.Schedules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fnf.FnfFunctions;
     * import com.pulumi.alicloud.fnf.inputs.GetSchedulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FnfFunctions.getSchedules(GetSchedulesArgs.builder()
     *             .flowName("example_value")
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstFnfScheduleId", example.applyValue(getSchedulesResult -> getSchedulesResult.schedules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:fnf:getSchedules
     *       Arguments:
     *         flowName: example_value
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstFnfScheduleId: ${example.schedules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSchedules.
     * @return A collection of values returned by getSchedules.
     */
    public suspend fun getSchedules(argument: GetSchedulesPlainArgs): GetSchedulesResult =
        getSchedulesResultToKotlin(getSchedulesPlain(argument.toJava()).await())

    /**
     * @see [getSchedules].
     * @param flowName The name of the flow bound to the time-based schedule you want to create.
     * @param ids A list of Schedule IDs.
     * @param limit The number of resource queries.
     * @param nameRegex A regex string to filter results by Schedule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getSchedules.
     */
    public suspend fun getSchedules(
        flowName: String,
        ids: List<String>? = null,
        limit: Int? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetSchedulesResult {
        val argument = GetSchedulesPlainArgs(
            flowName = flowName,
            ids = ids,
            limit = limit,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getSchedulesResultToKotlin(getSchedulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fnf&#46;kotlin&#46;inputs&#46;GetSchedulesPlainArgs].
     * @return A collection of values returned by getSchedules.
     */
    public suspend fun getSchedules(argument: suspend GetSchedulesPlainArgsBuilder.() -> Unit): GetSchedulesResult {
        val builder = GetSchedulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSchedulesResultToKotlin(getSchedulesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Fnf service automatically. If the service has been opened, it will return opened.
     * For information about Fnf and how to use it, see [What is Fnf](https://www.alibabacloud.com/help/en/product/113549.htm).
     * > **NOTE:** Available in v1.114.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.fnf.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.fnf.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.FNF.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := fnf.GetService(ctx, &fnf.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.fnf.FnfFunctions;
     * import com.pulumi.alicloud.fnf.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = FnfFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:fnf:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the Fnf service that means you have read and agreed the [Fnf Terms of Service](https://help.aliyun.com/document_detail/117831.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;fnf&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
