@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.alicloud.fnf.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * Provides a Serverless Workflow Schedule resource.
 * For information about Serverless Workflow Schedule and how to use it, see [What is Schedule](https://www.alibabacloud.com/help/en/doc-detail/168934.htm).
 * > **NOTE:** Available since v1.105.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.fnf.Flow("example", {
 *     definition: `  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `,
 *     description: "tf-exampleFnFFlow983041",
 *     name: "tf-exampleSchedule",
 *     type: "FDL",
 * });
 * const exampleSchedule = new alicloud.fnf.Schedule("example", {
 *     cronExpression: "30 9 * * * *",
 *     description: "tf-exampleFnFSchedule983041",
 *     enable: true,
 *     flowName: example.name,
 *     payload: "{\"tf-example\": \"example success\"}",
 *     scheduleName: "tf-exampleFnFSchedule983041",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.fnf.Flow("example",
 *     definition="""  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * """,
 *     description="tf-exampleFnFFlow983041",
 *     name="tf-exampleSchedule",
 *     type="FDL")
 * example_schedule = alicloud.fnf.Schedule("example",
 *     cron_expression="30 9 * * * *",
 *     description="tf-exampleFnFSchedule983041",
 *     enable=True,
 *     flow_name=example.name,
 *     payload="{\"tf-example\": \"example success\"}",
 *     schedule_name="tf-exampleFnFSchedule983041")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.FNF.Flow("example", new()
 *     {
 *         Definition = @"  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * ",
 *         Description = "tf-exampleFnFFlow983041",
 *         Name = "tf-exampleSchedule",
 *         Type = "FDL",
 *     });
 *     var exampleSchedule = new AliCloud.FNF.Schedule("example", new()
 *     {
 *         CronExpression = "30 9 * * * *",
 *         Description = "tf-exampleFnFSchedule983041",
 *         Enable = true,
 *         FlowName = example.Name,
 *         Payload = "{\"tf-example\": \"example success\"}",
 *         ScheduleName = "tf-exampleFnFSchedule983041",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := fnf.NewFlow(ctx, "example", &fnf.FlowArgs{
 * 			Definition: pulumi.String(`  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `),
 * 			Description: pulumi.String("tf-exampleFnFFlow983041"),
 * 			Name:        pulumi.String("tf-exampleSchedule"),
 * 			Type:        pulumi.String("FDL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fnf.NewSchedule(ctx, "example", &fnf.ScheduleArgs{
 * 			CronExpression: pulumi.String("30 9 * * * *"),
 * 			Description:    pulumi.String("tf-exampleFnFSchedule983041"),
 * 			Enable:         pulumi.Bool(true),
 * 			FlowName:       example.Name,
 * 			Payload:        pulumi.String("{\"tf-example\": \"example success\"}"),
 * 			ScheduleName:   pulumi.String("tf-exampleFnFSchedule983041"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.fnf.Flow;
 * import com.pulumi.alicloud.fnf.FlowArgs;
 * import com.pulumi.alicloud.fnf.Schedule;
 * import com.pulumi.alicloud.fnf.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Flow("example", FlowArgs.builder()
 *             .definition("""
 *   version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 *             """)
 *             .description("tf-exampleFnFFlow983041")
 *             .name("tf-exampleSchedule")
 *             .type("FDL")
 *             .build());
 *         var exampleSchedule = new Schedule("exampleSchedule", ScheduleArgs.builder()
 *             .cronExpression("30 9 * * * *")
 *             .description("tf-exampleFnFSchedule983041")
 *             .enable("true")
 *             .flowName(example.name())
 *             .payload("{\"tf-example\": \"example success\"}")
 *             .scheduleName("tf-exampleFnFSchedule983041")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:fnf:Flow
 *     properties:
 *       definition: |2
 *           version: v1beta1
 *           type: flow
 *           steps:
 *             - type: pass
 *               name: helloworld
 *       description: tf-exampleFnFFlow983041
 *       name: tf-exampleSchedule
 *       type: FDL
 *   exampleSchedule:
 *     type: alicloud:fnf:Schedule
 *     name: example
 *     properties:
 *       cronExpression: 30 9 * * * *
 *       description: tf-exampleFnFSchedule983041
 *       enable: 'true'
 *       flowName: ${example.name}
 *       payload: '{"tf-example": "example success"}'
 *       scheduleName: tf-exampleFnFSchedule983041
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless Workflow Schedule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fnf/schedule:Schedule example <schedule_name>:<flow_name>
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.alicloud.fnf.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * The CRON expression of the time-based schedule to be created.
     */
    public val cronExpression: Output<String>
        get() = javaResource.cronExpression().applyValue({ args0 -> args0 })

    /**
     * The description of the time-based schedule to be created.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable the time-based schedule you want to create. Valid values: `false`, `true`.
     */
    public val enable: Output<Boolean>?
        get() = javaResource.enable().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the flow bound to the time-based schedule you want to create.
     */
    public val flowName: Output<String>
        get() = javaResource.flowName().applyValue({ args0 -> args0 })

    /**
     * The time when the time-based schedule was last updated.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The trigger message of the time-based schedule to be created. It must be in JSON object format.
     */
    public val payload: Output<String>?
        get() = javaResource.payload().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the time-based schedule.
     */
    public val scheduleId: Output<String>
        get() = javaResource.scheduleId().applyValue({ args0 -> args0 })

    /**
     * The name of the time-based schedule to be created.
     */
    public val scheduleName: Output<String>
        get() = javaResource.scheduleName().applyValue({ args0 -> args0 })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.fnf.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.alicloud.fnf.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
