@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin

import com.pulumi.alicloud.fnf.ScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Serverless Workflow Schedule resource.
 * For information about Serverless Workflow Schedule and how to use it, see [What is Schedule](https://www.alibabacloud.com/help/en/doc-detail/168934.htm).
 * > **NOTE:** Available since v1.105.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.fnf.Flow("example", {
 *     definition: `  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `,
 *     description: "tf-exampleFnFFlow983041",
 *     name: "tf-exampleSchedule",
 *     type: "FDL",
 * });
 * const exampleSchedule = new alicloud.fnf.Schedule("example", {
 *     cronExpression: "30 9 * * * *",
 *     description: "tf-exampleFnFSchedule983041",
 *     enable: true,
 *     flowName: example.name,
 *     payload: "{\"tf-example\": \"example success\"}",
 *     scheduleName: "tf-exampleFnFSchedule983041",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.fnf.Flow("example",
 *     definition="""  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * """,
 *     description="tf-exampleFnFFlow983041",
 *     name="tf-exampleSchedule",
 *     type="FDL")
 * example_schedule = alicloud.fnf.Schedule("example",
 *     cron_expression="30 9 * * * *",
 *     description="tf-exampleFnFSchedule983041",
 *     enable=True,
 *     flow_name=example.name,
 *     payload="{\"tf-example\": \"example success\"}",
 *     schedule_name="tf-exampleFnFSchedule983041")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.FNF.Flow("example", new()
 *     {
 *         Definition = @"  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * ",
 *         Description = "tf-exampleFnFFlow983041",
 *         Name = "tf-exampleSchedule",
 *         Type = "FDL",
 *     });
 *     var exampleSchedule = new AliCloud.FNF.Schedule("example", new()
 *     {
 *         CronExpression = "30 9 * * * *",
 *         Description = "tf-exampleFnFSchedule983041",
 *         Enable = true,
 *         FlowName = example.Name,
 *         Payload = "{\"tf-example\": \"example success\"}",
 *         ScheduleName = "tf-exampleFnFSchedule983041",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/fnf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := fnf.NewFlow(ctx, "example", &fnf.FlowArgs{
 * 			Definition: pulumi.String(`  version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 * `),
 * 			Description: pulumi.String("tf-exampleFnFFlow983041"),
 * 			Name:        pulumi.String("tf-exampleSchedule"),
 * 			Type:        pulumi.String("FDL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fnf.NewSchedule(ctx, "example", &fnf.ScheduleArgs{
 * 			CronExpression: pulumi.String("30 9 * * * *"),
 * 			Description:    pulumi.String("tf-exampleFnFSchedule983041"),
 * 			Enable:         pulumi.Bool(true),
 * 			FlowName:       example.Name,
 * 			Payload:        pulumi.String("{\"tf-example\": \"example success\"}"),
 * 			ScheduleName:   pulumi.String("tf-exampleFnFSchedule983041"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.fnf.Flow;
 * import com.pulumi.alicloud.fnf.FlowArgs;
 * import com.pulumi.alicloud.fnf.Schedule;
 * import com.pulumi.alicloud.fnf.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Flow("example", FlowArgs.builder()
 *             .definition("""
 *   version: v1beta1
 *   type: flow
 *   steps:
 *     - type: pass
 *       name: helloworld
 *             """)
 *             .description("tf-exampleFnFFlow983041")
 *             .name("tf-exampleSchedule")
 *             .type("FDL")
 *             .build());
 *         var exampleSchedule = new Schedule("exampleSchedule", ScheduleArgs.builder()
 *             .cronExpression("30 9 * * * *")
 *             .description("tf-exampleFnFSchedule983041")
 *             .enable("true")
 *             .flowName(example.name())
 *             .payload("{\"tf-example\": \"example success\"}")
 *             .scheduleName("tf-exampleFnFSchedule983041")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:fnf:Flow
 *     properties:
 *       definition: |2
 *           version: v1beta1
 *           type: flow
 *           steps:
 *             - type: pass
 *               name: helloworld
 *       description: tf-exampleFnFFlow983041
 *       name: tf-exampleSchedule
 *       type: FDL
 *   exampleSchedule:
 *     type: alicloud:fnf:Schedule
 *     name: example
 *     properties:
 *       cronExpression: 30 9 * * * *
 *       description: tf-exampleFnFSchedule983041
 *       enable: 'true'
 *       flowName: ${example.name}
 *       payload: '{"tf-example": "example success"}'
 *       scheduleName: tf-exampleFnFSchedule983041
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless Workflow Schedule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:fnf/schedule:Schedule example <schedule_name>:<flow_name>
 * ```
 * @property cronExpression The CRON expression of the time-based schedule to be created.
 * @property description The description of the time-based schedule to be created.
 * @property enable Specifies whether to enable the time-based schedule you want to create. Valid values: `false`, `true`.
 * @property flowName The name of the flow bound to the time-based schedule you want to create.
 * @property payload The trigger message of the time-based schedule to be created. It must be in JSON object format.
 * @property scheduleName The name of the time-based schedule to be created.
 */
public data class ScheduleArgs(
    public val cronExpression: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val flowName: Output<String>? = null,
    public val payload: Output<String>? = null,
    public val scheduleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fnf.ScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.fnf.ScheduleArgs =
        com.pulumi.alicloud.fnf.ScheduleArgs.builder()
            .cronExpression(cronExpression?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .flowName(flowName?.applyValue({ args0 -> args0 }))
            .payload(payload?.applyValue({ args0 -> args0 }))
            .scheduleName(scheduleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var cronExpression: Output<String>? = null

    private var description: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var flowName: Output<String>? = null

    private var payload: Output<String>? = null

    private var scheduleName: Output<String>? = null

    /**
     * @param value The CRON expression of the time-based schedule to be created.
     */
    @JvmName("tavixltepotpyrjq")
    public suspend fun cronExpression(`value`: Output<String>) {
        this.cronExpression = value
    }

    /**
     * @param value The description of the time-based schedule to be created.
     */
    @JvmName("bohyesfxetpcbjgr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to enable the time-based schedule you want to create. Valid values: `false`, `true`.
     */
    @JvmName("elboiwqahgxvtujm")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The name of the flow bound to the time-based schedule you want to create.
     */
    @JvmName("paaqpsiuflfamqdg")
    public suspend fun flowName(`value`: Output<String>) {
        this.flowName = value
    }

    /**
     * @param value The trigger message of the time-based schedule to be created. It must be in JSON object format.
     */
    @JvmName("xpwsvdwcupvorwqh")
    public suspend fun payload(`value`: Output<String>) {
        this.payload = value
    }

    /**
     * @param value The name of the time-based schedule to be created.
     */
    @JvmName("okfrscqanuwewuex")
    public suspend fun scheduleName(`value`: Output<String>) {
        this.scheduleName = value
    }

    /**
     * @param value The CRON expression of the time-based schedule to be created.
     */
    @JvmName("xmudlosjkvtueqmt")
    public suspend fun cronExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cronExpression = mapped
    }

    /**
     * @param value The description of the time-based schedule to be created.
     */
    @JvmName("ttkwqscdhkdxjspn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to enable the time-based schedule you want to create. Valid values: `false`, `true`.
     */
    @JvmName("jvmmlbxavuyxpvfc")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The name of the flow bound to the time-based schedule you want to create.
     */
    @JvmName("qwdwbfxjxhrvmnjf")
    public suspend fun flowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowName = mapped
    }

    /**
     * @param value The trigger message of the time-based schedule to be created. It must be in JSON object format.
     */
    @JvmName("ejilnsypqasqmxyc")
    public suspend fun payload(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payload = mapped
    }

    /**
     * @param value The name of the time-based schedule to be created.
     */
    @JvmName("icjfdtsebxgdcagb")
    public suspend fun scheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleName = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        cronExpression = cronExpression,
        description = description,
        enable = enable,
        flowName = flowName,
        payload = payload,
        scheduleName = scheduleName,
    )
}
