@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.inputs

import com.pulumi.alicloud.fnf.inputs.GetExecutionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExecutions.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property flowName The name of the flow.
 * @property ids A list of Execution IDs. The value formats as `<flow_name>:<execution_name>`.
 * @property nameRegex A regex string to filter results by Execution name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `Running`, `Stopped`, `Succeeded`, `Failed`, `TimedOut`.
 */
public data class GetExecutionsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val flowName: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fnf.inputs.GetExecutionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.fnf.inputs.GetExecutionsPlainArgs =
        com.pulumi.alicloud.fnf.inputs.GetExecutionsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .flowName(flowName.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExecutionsPlainArgs].
 */
@PulumiTagMarker
public class GetExecutionsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var flowName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("udrykiommhaklwdf")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The name of the flow.
     */
    @JvmName("eirmnshvdnllighu")
    public suspend fun flowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.flowName = mapped
    }

    /**
     * @param value A list of Execution IDs. The value formats as `<flow_name>:<execution_name>`.
     */
    @JvmName("wnfyqelpamwgbglc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Execution IDs. The value formats as `<flow_name>:<execution_name>`.
     */
    @JvmName("ukghbirkqmmeduij")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Execution name.
     */
    @JvmName("swnnfabkojyuqtoo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wdbtevbtipjkrwmb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Running`, `Stopped`, `Succeeded`, `Failed`, `TimedOut`.
     */
    @JvmName("uawdmswrsusagbvu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetExecutionsPlainArgs = GetExecutionsPlainArgs(
        enableDetails = enableDetails,
        flowName = flowName ?: throw PulumiNullFieldException("flowName"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
