@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.inputs

import com.pulumi.alicloud.fnf.inputs.GetFlowsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFlows.
 * @property ids A list of Flow IDs.
 * @property limit The number of resource queries.
 * @property nameRegex A regex string to filter results by Flow name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetFlowsPlainArgs(
    public val ids: List<String>? = null,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fnf.inputs.GetFlowsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.fnf.inputs.GetFlowsPlainArgs =
        com.pulumi.alicloud.fnf.inputs.GetFlowsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .limit(limit?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFlowsPlainArgs].
 */
@PulumiTagMarker
public class GetFlowsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var limit: Int? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Flow IDs.
     */
    @JvmName("hibruhukdqwnsrbv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Flow IDs.
     */
    @JvmName("rivgglgiekjkrvdm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The number of resource queries.
     */
    @JvmName("ynovctoxfuhbcfyf")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.limit = mapped
    }

    /**
     * @param value A regex string to filter results by Flow name.
     */
    @JvmName("uioylvlfdnwqtsfs")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("btkgitedfgghghud")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetFlowsPlainArgs = GetFlowsPlainArgs(
        ids = ids,
        limit = limit,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
