@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.inputs

import com.pulumi.alicloud.fnf.inputs.GetSchedulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSchedules.
 * @property flowName The name of the flow bound to the time-based schedule you want to create.
 * @property ids A list of Schedule IDs.
 * @property limit The number of resource queries.
 * @property nameRegex A regex string to filter results by Schedule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetSchedulesPlainArgs(
    public val flowName: String,
    public val ids: List<String>? = null,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fnf.inputs.GetSchedulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.fnf.inputs.GetSchedulesPlainArgs =
        com.pulumi.alicloud.fnf.inputs.GetSchedulesPlainArgs.builder()
            .flowName(flowName.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .limit(limit?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSchedulesPlainArgs].
 */
@PulumiTagMarker
public class GetSchedulesPlainArgsBuilder internal constructor() {
    private var flowName: String? = null

    private var ids: List<String>? = null

    private var limit: Int? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the flow bound to the time-based schedule you want to create.
     */
    @JvmName("sqnwyvhnkmemqhry")
    public suspend fun flowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.flowName = mapped
    }

    /**
     * @param value A list of Schedule IDs.
     */
    @JvmName("aydyonokyoocuafo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Schedule IDs.
     */
    @JvmName("fnpjjwjegmexcgqd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The number of resource queries.
     */
    @JvmName("qnolksndxsknjxqu")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.limit = mapped
    }

    /**
     * @param value A regex string to filter results by Schedule name.
     */
    @JvmName("yyticdpyhcfqxcbn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wxclxqgxhibjwrmc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetSchedulesPlainArgs = GetSchedulesPlainArgs(
        flowName = flowName ?: throw PulumiNullFieldException("flowName"),
        ids = ids,
        limit = limit,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
