@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property executionName The name of the execution.
 * @property flowName The name of the flow.
 * @property id The ID of the Execution. The value formats as `<flow_name>:<execution_name>`.
 * @property input The Input information for this execution.
 * @property output The output of the execution.
 * @property startedTime The started time of the execution.
 * @property status The status of the resource.
 * @property stoppedTime The stopped time of the execution.
 */
public data class GetExecutionsExecution(
    public val executionName: String,
    public val flowName: String,
    public val id: String,
    public val input: String,
    public val output: String,
    public val startedTime: String,
    public val status: String,
    public val stoppedTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fnf.outputs.GetExecutionsExecution): GetExecutionsExecution = GetExecutionsExecution(
            executionName = javaType.executionName(),
            flowName = javaType.flowName(),
            id = javaType.id(),
            input = javaType.input(),
            output = javaType.output(),
            startedTime = javaType.startedTime(),
            status = javaType.status(),
            stoppedTime = javaType.stoppedTime(),
        )
    }
}
