@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property definition The definition of the flow. It must comply with the Flow Definition Language (FDL) syntax.
 * @property description The description of the flow.
 * @property flowId The unique ID of the flow.
 * @property id The ID of the Flow.
 * @property lastModifiedTime The time when the flow was last modified.
 * @property name The name of the flow. The name must be unique in an Alibaba Cloud account.
 * @property roleArn The ARN of the specified RAM role that Serverless Workflow uses to assume the role when Serverless Workflow executes a flow.
 * @property type The type of the flow. Set the value to `FDL`.
 */
public data class GetFlowsFlow(
    public val definition: String,
    public val description: String,
    public val flowId: String,
    public val id: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val roleArn: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fnf.outputs.GetFlowsFlow): GetFlowsFlow =
            GetFlowsFlow(
                definition = javaType.definition(),
                description = javaType.description(),
                flowId = javaType.flowId(),
                id = javaType.id(),
                lastModifiedTime = javaType.lastModifiedTime(),
                name = javaType.name(),
                roleArn = javaType.roleArn(),
                type = javaType.type(),
            )
    }
}
