@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFlows.
 * @property flows
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property limit
 * @property nameRegex
 * @property names
 * @property outputFile
 */
public data class GetFlowsResult(
    public val flows: List<GetFlowsFlow>,
    public val id: String,
    public val ids: List<String>,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fnf.outputs.GetFlowsResult): GetFlowsResult =
            GetFlowsResult(
                flows = javaType.flows().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.fnf.kotlin.outputs.GetFlowsFlow.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                limit = javaType.limit().map({ args0 -> args0 }).orElse(null),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            )
    }
}
