@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fnf.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cronExpression The CRON expression of the time-based schedule to be created.
 * @property description The description of the time-based schedule to be created.
 * @property enable Specifies whether to enable the time-based schedule you want to create.
 * @property id The ID of the Schedule.
 * @property lastModifiedTime The time when the time-based schedule was last updated.
 * @property payload The trigger message of the time-based schedule to be created. It must be in JSON object format.
 * @property scheduleId The ID of the time-based schedule.
 * @property scheduleName The name of the time-based schedule to be created.
 */
public data class GetSchedulesSchedule(
    public val cronExpression: String,
    public val description: String,
    public val enable: Boolean,
    public val id: String,
    public val lastModifiedTime: String,
    public val payload: String,
    public val scheduleId: String,
    public val scheduleName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fnf.outputs.GetSchedulesSchedule): GetSchedulesSchedule = GetSchedulesSchedule(
            cronExpression = javaType.cronExpression(),
            description = javaType.description(),
            enable = javaType.enable(),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            payload = javaType.payload(),
            scheduleId = javaType.scheduleId(),
            scheduleName = javaType.scheduleName(),
        )
    }
}
