@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Accelerator].
 */
@PulumiTagMarker
public class AcceleratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AcceleratorArgs = AcceleratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AcceleratorArgsBuilder.() -> Unit) {
        val builder = AcceleratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Accelerator {
        val builtJavaResource = com.pulumi.alicloud.ga.Accelerator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Accelerator(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Accelerator resource.
 * For information about Global Accelerator (GA) Accelerator and how to use it, see [What is Accelerator](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createaccelerator).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ga.Accelerator("example", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ga.Accelerator("example",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ga.Accelerator("example", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAccelerator(ctx, "example", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Accelerator("example", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Accelerator can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/accelerator:Accelerator example <id>
 * ```
 */
public class Accelerator internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.Accelerator,
) : KotlinCustomResource(javaResource, AcceleratorMapper) {
    /**
     * The Name of the GA instance.
     */
    public val acceleratorName: Output<String>?
        get() = javaResource.acceleratorName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auto renewal period of an instance, in the unit of month. The value range is 1-12.
     */
    public val autoRenewDuration: Output<Int>
        get() = javaResource.autoRenewDuration().applyValue({ args0 -> args0 })

    /**
     * Use coupons to pay bills automatically. Default value: `false`. Valid values:
     */
    public val autoUseCoupon: Output<Boolean>?
        get() = javaResource.autoUseCoupon().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
     * - `BandwidthPackage`: billed based on bandwidth plans.
     * - `CDT`: billed based on data transfer.
     */
    public val bandwidthBillingType: Output<String>
        get() = javaResource.bandwidthBillingType().applyValue({ args0 -> args0 })

    /**
     * The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
     */
    public val crossBorderMode: Output<String>
        get() = javaResource.crossBorderMode().applyValue({ args0 -> args0 })

    /**
     * Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
     */
    public val crossBorderStatus: Output<Boolean>?
        get() = javaResource.crossBorderStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Descriptive information of the global acceleration instance.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subscription duration.
     * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
     * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
     */
    public val duration: Output<Int>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The billing cycle of the GA instance. Default value: `Month`. Valid values:
     * - `Month`: billed on a monthly basis.
     * - `Year`: billed on an annual basis.
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    public val promotionOptionNo: Output<String>?
        get() = javaResource.promotionOptionNo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The instance type of the GA instance. Specification of global acceleration instance. Valid values:
     */
    public val spec: Output<String>?
        get() = javaResource.spec().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the GA instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AcceleratorMapper : ResourceMapper<Accelerator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.Accelerator::class == javaResource::class

    override fun map(javaResource: Resource): Accelerator = Accelerator(
        javaResource as
            com.pulumi.alicloud.ga.Accelerator,
    )
}

/**
 * @see [Accelerator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Accelerator].
 */
public suspend fun accelerator(name: String, block: suspend AcceleratorResourceBuilder.() -> Unit): Accelerator {
    val builder = AcceleratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Accelerator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accelerator(name: String): Accelerator {
    val builder = AcceleratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
