@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.AcceleratorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Accelerator resource.
 * For information about Global Accelerator (GA) Accelerator and how to use it, see [What is Accelerator](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createaccelerator).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ga.Accelerator("example", {
 *     duration: 1,
 *     autoUseCoupon: true,
 *     spec: "1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ga.Accelerator("example",
 *     duration=1,
 *     auto_use_coupon=True,
 *     spec="1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ga.Accelerator("example", new()
 *     {
 *         Duration = 1,
 *         AutoUseCoupon = true,
 *         Spec = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAccelerator(ctx, "example", &ga.AcceleratorArgs{
 * 			Duration:      pulumi.Int(1),
 * 			AutoUseCoupon: pulumi.Bool(true),
 * 			Spec:          pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Accelerator;
 * import com.pulumi.alicloud.ga.AcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Accelerator("example", AcceleratorArgs.builder()
 *             .duration(1)
 *             .autoUseCoupon(true)
 *             .spec("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ga:Accelerator
 *     properties:
 *       duration: 1
 *       autoUseCoupon: true
 *       spec: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Accelerator can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/accelerator:Accelerator example <id>
 * ```
 * @property acceleratorName The Name of the GA instance.
 * @property autoRenewDuration Auto renewal period of an instance, in the unit of month. The value range is 1-12.
 * @property autoUseCoupon Use coupons to pay bills automatically. Default value: `false`. Valid values:
 * @property bandwidthBillingType The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
 * - `BandwidthPackage`: billed based on bandwidth plans.
 * - `CDT`: billed based on data transfer.
 * @property crossBorderMode The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
 * @property crossBorderStatus Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
 * @property description Descriptive information of the global acceleration instance.
 * @property duration The subscription duration.
 * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
 * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
 * @property paymentType The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
 * @property pricingCycle The billing cycle of the GA instance. Default value: `Month`. Valid values:
 * - `Month`: billed on a monthly basis.
 * - `Year`: billed on an annual basis.
 * @property promotionOptionNo The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
 * @property renewalStatus Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
 * - `AutoRenewal`: Enable auto renewal.
 * - `Normal`: Disable auto renewal.
 * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
 * @property resourceGroupId The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property spec The instance type of the GA instance. Specification of global acceleration instance. Valid values:
 * @property tags A mapping of tags to assign to the resource.
 */
public data class AcceleratorArgs(
    public val acceleratorName: Output<String>? = null,
    public val autoRenewDuration: Output<Int>? = null,
    public val autoUseCoupon: Output<Boolean>? = null,
    public val bandwidthBillingType: Output<String>? = null,
    public val crossBorderMode: Output<String>? = null,
    public val crossBorderStatus: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val duration: Output<Int>? = null,
    public val paymentType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val promotionOptionNo: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val spec: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.AcceleratorArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.AcceleratorArgs =
        com.pulumi.alicloud.ga.AcceleratorArgs.builder()
            .acceleratorName(acceleratorName?.applyValue({ args0 -> args0 }))
            .autoRenewDuration(autoRenewDuration?.applyValue({ args0 -> args0 }))
            .autoUseCoupon(autoUseCoupon?.applyValue({ args0 -> args0 }))
            .bandwidthBillingType(bandwidthBillingType?.applyValue({ args0 -> args0 }))
            .crossBorderMode(crossBorderMode?.applyValue({ args0 -> args0 }))
            .crossBorderStatus(crossBorderStatus?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .promotionOptionNo(promotionOptionNo?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AcceleratorArgs].
 */
@PulumiTagMarker
public class AcceleratorArgsBuilder internal constructor() {
    private var acceleratorName: Output<String>? = null

    private var autoRenewDuration: Output<Int>? = null

    private var autoUseCoupon: Output<Boolean>? = null

    private var bandwidthBillingType: Output<String>? = null

    private var crossBorderMode: Output<String>? = null

    private var crossBorderStatus: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var duration: Output<Int>? = null

    private var paymentType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var promotionOptionNo: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var spec: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Name of the GA instance.
     */
    @JvmName("qhmavcrpvwoycygr")
    public suspend fun acceleratorName(`value`: Output<String>) {
        this.acceleratorName = value
    }

    /**
     * @param value Auto renewal period of an instance, in the unit of month. The value range is 1-12.
     */
    @JvmName("kemfrooejmmguyxd")
    public suspend fun autoRenewDuration(`value`: Output<Int>) {
        this.autoRenewDuration = value
    }

    /**
     * @param value Use coupons to pay bills automatically. Default value: `false`. Valid values:
     */
    @JvmName("scmlffcxgoetetdr")
    public suspend fun autoUseCoupon(`value`: Output<Boolean>) {
        this.autoUseCoupon = value
    }

    /**
     * @param value The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
     * - `BandwidthPackage`: billed based on bandwidth plans.
     * - `CDT`: billed based on data transfer.
     */
    @JvmName("ycbdmgfnvrorddnn")
    public suspend fun bandwidthBillingType(`value`: Output<String>) {
        this.bandwidthBillingType = value
    }

    /**
     * @param value The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
     */
    @JvmName("uwwpwwtftxgfpdrt")
    public suspend fun crossBorderMode(`value`: Output<String>) {
        this.crossBorderMode = value
    }

    /**
     * @param value Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
     */
    @JvmName("ifisdodylapowlmu")
    public suspend fun crossBorderStatus(`value`: Output<Boolean>) {
        this.crossBorderStatus = value
    }

    /**
     * @param value Descriptive information of the global acceleration instance.
     */
    @JvmName("qbpmtmhobqbssxwk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The subscription duration.
     * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
     * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
     */
    @JvmName("dlnbfgaxdjymcjnv")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("thkwbindanuqyesm")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The billing cycle of the GA instance. Default value: `Month`. Valid values:
     * - `Month`: billed on a monthly basis.
     * - `Year`: billed on an annual basis.
     */
    @JvmName("cqyfvtbbimhvkgvp")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    @JvmName("afmqlsbctbsaajbk")
    public suspend fun promotionOptionNo(`value`: Output<String>) {
        this.promotionOptionNo = value
    }

    /**
     * @param value Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    @JvmName("ncbdwxilotacovlk")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("ywpugvmpkfksfqxr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The instance type of the GA instance. Specification of global acceleration instance. Valid values:
     */
    @JvmName("reuewpcdlqfvfcia")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jtupyalymedfwlmy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Name of the GA instance.
     */
    @JvmName("kkeepppjapjqhmus")
    public suspend fun acceleratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorName = mapped
    }

    /**
     * @param value Auto renewal period of an instance, in the unit of month. The value range is 1-12.
     */
    @JvmName("qlifrmfkdunsbppt")
    public suspend fun autoRenewDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewDuration = mapped
    }

    /**
     * @param value Use coupons to pay bills automatically. Default value: `false`. Valid values:
     */
    @JvmName("qiyadgqtsxctvumx")
    public suspend fun autoUseCoupon(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUseCoupon = mapped
    }

    /**
     * @param value The bandwidth billing method. Default value: `BandwidthPackage`. Valid values:
     * - `BandwidthPackage`: billed based on bandwidth plans.
     * - `CDT`: billed based on data transfer.
     */
    @JvmName("qyujaadjnosymune")
    public suspend fun bandwidthBillingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthBillingType = mapped
    }

    /**
     * @param value The type of cross-border acceleration. Default value: `bgpPro`. Valid values: `bgpPro`, `private`. **NOTE:** `cross_border_mode` is valid only when `cross_border_status` is set to `true`.
     */
    @JvmName("gfmgrntiwrabykdq")
    public suspend fun crossBorderMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossBorderMode = mapped
    }

    /**
     * @param value Indicates whether cross-border acceleration is enabled. Default value: `false`. Valid values:
     */
    @JvmName("duviamcqtgmriysv")
    public suspend fun crossBorderStatus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossBorderStatus = mapped
    }

    /**
     * @param value Descriptive information of the global acceleration instance.
     */
    @JvmName("rlsbtuijndgfhvrk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The subscription duration.
     * * If the `pricing_cycle` parameter is set to `Month`, the valid values for the `duration` parameter are 1 to 9.
     * * If the `pricing_cycle` parameter is set to `Year`, the valid values for the `duration` parameter are 1 to 3.
     */
    @JvmName("hlqythxvgnbblato")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The payment type. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("kvrwiibqyitfsgoc")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The billing cycle of the GA instance. Default value: `Month`. Valid values:
     * - `Month`: billed on a monthly basis.
     * - `Year`: billed on an annual basis.
     */
    @JvmName("lglddputigahxaqu")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    @JvmName("xuiuoiscvyvxfqqu")
    public suspend fun promotionOptionNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionOptionNo = mapped
    }

    /**
     * @param value Whether to renew an accelerator automatically or not. Default value: `Normal`. Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    @JvmName("xkglwhnpcxeveemg")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("cjlltbsrmjkobfma")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The instance type of the GA instance. Specification of global acceleration instance. Valid values:
     */
    @JvmName("ynyceaxijfdjrxib")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("gxvhhrtvcraglaha")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("qxlxtbtrcbvnycfx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AcceleratorArgs = AcceleratorArgs(
        acceleratorName = acceleratorName,
        autoRenewDuration = autoRenewDuration,
        autoUseCoupon = autoUseCoupon,
        bandwidthBillingType = bandwidthBillingType,
        crossBorderMode = crossBorderMode,
        crossBorderStatus = crossBorderStatus,
        description = description,
        duration = duration,
        paymentType = paymentType,
        pricingCycle = pricingCycle,
        promotionOptionNo = promotionOptionNo,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        spec = spec,
        tags = tags,
    )
}
