@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.kotlin.outputs.AclAclEntry
import com.pulumi.alicloud.ga.kotlin.outputs.AclAclEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Acl].
 */
@PulumiTagMarker
public class AclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclArgs = AclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclArgsBuilder.() -> Unit) {
        val builder = AclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Acl {
        val builtJavaResource = com.pulumi.alicloud.ga.Acl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Acl(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Acl resource.
 * For information about Global Accelerator (GA) Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createacl).
 * > **NOTE:** Available since v1.150.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Acl("default", {
 *     aclName: "terraform-example",
 *     addressIpVersion: "IPv4",
 * });
 * const defaultAclEntryAttachment = new alicloud.ga.AclEntryAttachment("default", {
 *     aclId: _default.id,
 *     entry: "192.168.1.1/32",
 *     entryDescription: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Acl("default",
 *     acl_name="terraform-example",
 *     address_ip_version="IPv4")
 * default_acl_entry_attachment = alicloud.ga.AclEntryAttachment("default",
 *     acl_id=default.id,
 *     entry="192.168.1.1/32",
 *     entry_description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Acl("default", new()
 *     {
 *         AclName = "terraform-example",
 *         AddressIpVersion = "IPv4",
 *     });
 *     var defaultAclEntryAttachment = new AliCloud.Ga.AclEntryAttachment("default", new()
 *     {
 *         AclId = @default.Id,
 *         Entry = "192.168.1.1/32",
 *         EntryDescription = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAcl(ctx, "default", &ga.AclArgs{
 * 			AclName:          pulumi.String("terraform-example"),
 * 			AddressIpVersion: pulumi.String("IPv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewAclEntryAttachment(ctx, "default", &ga.AclEntryAttachmentArgs{
 * 			AclId:            _default.ID(),
 * 			Entry:            pulumi.String("192.168.1.1/32"),
 * 			EntryDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Acl;
 * import com.pulumi.alicloud.ga.AclArgs;
 * import com.pulumi.alicloud.ga.AclEntryAttachment;
 * import com.pulumi.alicloud.ga.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .aclName("terraform-example")
 *             .addressIpVersion("IPv4")
 *             .build());
 *         var defaultAclEntryAttachment = new AclEntryAttachment("defaultAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(default_.id())
 *             .entry("192.168.1.1/32")
 *             .entryDescription("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Acl
 *     properties:
 *       aclName: terraform-example
 *       addressIpVersion: IPv4
 *   defaultAclEntryAttachment:
 *     type: alicloud:ga:AclEntryAttachment
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       entry: 192.168.1.1/32
 *       entryDescription: terraform-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/acl:Acl example <id>
 * ```
 */
public class Acl internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.Acl,
) : KotlinCustomResource(javaResource, AclMapper) {
    /**
     * The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    public val aclEntries: Output<List<AclAclEntry>>
        get() = javaResource.aclEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
     */
    public val aclName: Output<String>?
        get() = javaResource.aclName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IP version. Valid values: `IPv4` and `IPv6`.
     */
    public val addressIpVersion: Output<String>
        get() = javaResource.addressIpVersion().applyValue({ args0 -> args0 })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AclMapper : ResourceMapper<Acl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.Acl::class == javaResource::class

    override fun map(javaResource: Resource): Acl = Acl(javaResource as com.pulumi.alicloud.ga.Acl)
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Acl].
 */
public suspend fun acl(name: String, block: suspend AclResourceBuilder.() -> Unit): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun acl(name: String): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    return builder.build()
}
