@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.AclArgs.builder
import com.pulumi.alicloud.ga.kotlin.inputs.AclAclEntryArgs
import com.pulumi.alicloud.ga.kotlin.inputs.AclAclEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Acl resource.
 * For information about Global Accelerator (GA) Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createacl).
 * > **NOTE:** Available since v1.150.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Acl("default", {
 *     aclName: "terraform-example",
 *     addressIpVersion: "IPv4",
 * });
 * const defaultAclEntryAttachment = new alicloud.ga.AclEntryAttachment("default", {
 *     aclId: _default.id,
 *     entry: "192.168.1.1/32",
 *     entryDescription: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Acl("default",
 *     acl_name="terraform-example",
 *     address_ip_version="IPv4")
 * default_acl_entry_attachment = alicloud.ga.AclEntryAttachment("default",
 *     acl_id=default.id,
 *     entry="192.168.1.1/32",
 *     entry_description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Acl("default", new()
 *     {
 *         AclName = "terraform-example",
 *         AddressIpVersion = "IPv4",
 *     });
 *     var defaultAclEntryAttachment = new AliCloud.Ga.AclEntryAttachment("default", new()
 *     {
 *         AclId = @default.Id,
 *         Entry = "192.168.1.1/32",
 *         EntryDescription = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAcl(ctx, "default", &ga.AclArgs{
 * 			AclName:          pulumi.String("terraform-example"),
 * 			AddressIpVersion: pulumi.String("IPv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewAclEntryAttachment(ctx, "default", &ga.AclEntryAttachmentArgs{
 * 			AclId:            _default.ID(),
 * 			Entry:            pulumi.String("192.168.1.1/32"),
 * 			EntryDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Acl;
 * import com.pulumi.alicloud.ga.AclArgs;
 * import com.pulumi.alicloud.ga.AclEntryAttachment;
 * import com.pulumi.alicloud.ga.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .aclName("terraform-example")
 *             .addressIpVersion("IPv4")
 *             .build());
 *         var defaultAclEntryAttachment = new AclEntryAttachment("defaultAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(default_.id())
 *             .entry("192.168.1.1/32")
 *             .entryDescription("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Acl
 *     properties:
 *       aclName: terraform-example
 *       addressIpVersion: IPv4
 *   defaultAclEntryAttachment:
 *     type: alicloud:ga:AclEntryAttachment
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       entry: 192.168.1.1/32
 *       entryDescription: terraform-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/acl:Acl example <id>
 * ```
 * @property aclEntries The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
 * @property aclName The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
 * @property addressIpVersion The IP version. Valid values: `IPv4` and `IPv6`.
 * @property dryRun The dry run.
 * @property resourceGroupId The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class AclArgs(
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    public val aclEntries: Output<List<AclAclEntryArgs>>? = null,
    public val aclName: Output<String>? = null,
    public val addressIpVersion: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.AclArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.AclArgs = com.pulumi.alicloud.ga.AclArgs.builder()
        .aclEntries(
            aclEntries?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .aclName(aclName?.applyValue({ args0 -> args0 }))
        .addressIpVersion(addressIpVersion?.applyValue({ args0 -> args0 }))
        .dryRun(dryRun?.applyValue({ args0 -> args0 }))
        .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AclArgs].
 */
@PulumiTagMarker
public class AclArgsBuilder internal constructor() {
    private var aclEntries: Output<List<AclAclEntryArgs>>? = null

    private var aclName: Output<String>? = null

    private var addressIpVersion: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("yshulmhghymefagm")
    public suspend fun aclEntries(`value`: Output<List<AclAclEntryArgs>>) {
        this.aclEntries = value
    }

    @JvmName("swfgjbwmmgsprtkn")
    public suspend fun aclEntries(vararg values: Output<AclAclEntryArgs>) {
        this.aclEntries = Output.all(values.asList())
    }

    /**
     * @param values The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("khnsrsptlsynivxx")
    public suspend fun aclEntries(values: List<Output<AclAclEntryArgs>>) {
        this.aclEntries = Output.all(values)
    }

    /**
     * @param value The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
     */
    @JvmName("nglqtqffyruqtjoq")
    public suspend fun aclName(`value`: Output<String>) {
        this.aclName = value
    }

    /**
     * @param value The IP version. Valid values: `IPv4` and `IPv6`.
     */
    @JvmName("fvhdfsnmtguxqnig")
    public suspend fun addressIpVersion(`value`: Output<String>) {
        this.addressIpVersion = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("gxvgqbrhoryylixy")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("kysfwbtidblqrmfi")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ldkvmssrhcrludin")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("bbxxwokaxfglyfwo")
    public suspend fun aclEntries(`value`: List<AclAclEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclEntries = mapped
    }

    /**
     * @param argument The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("sarmjieveeagydce")
    public suspend fun aclEntries(argument: List<suspend AclAclEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AclAclEntryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aclEntries = mapped
    }

    /**
     * @param argument The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("ucmgvstqvctyiydm")
    public suspend fun aclEntries(vararg argument: suspend AclAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AclAclEntryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aclEntries = mapped
    }

    /**
     * @param argument The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("yhbrijpsbwhxmyqu")
    public suspend fun aclEntries(argument: suspend AclAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AclAclEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aclEntries = mapped
    }

    /**
     * @param values The entries of the Acl. See `acl_entries` below. **NOTE:** "Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`."
     */
    @Deprecated(
        message = """
  Field `acl_entries` has been deprecated from provider version 1.190.0 and it will be removed in
      the future version. Please use the new resource `alicloud.ga.AclEntryAttachment`.
  """,
    )
    @JvmName("jpcqawewvxnirlhd")
    public suspend fun aclEntries(vararg values: AclAclEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aclEntries = mapped
    }

    /**
     * @param value The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), hyphens (-) and underscores (_). It must start with a letter.
     */
    @JvmName("pcspwpbljwufakuu")
    public suspend fun aclName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclName = mapped
    }

    /**
     * @param value The IP version. Valid values: `IPv4` and `IPv6`.
     */
    @JvmName("eursktheylxewvfn")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressIpVersion = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("ythhprtdywrquwid")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("kyqeyyvjqnnxuixs")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("dqrnalrgdafechnd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ymtdycrxydkdcyvh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AclArgs = AclArgs(
        aclEntries = aclEntries,
        aclName = aclName,
        addressIpVersion = addressIpVersion,
        dryRun = dryRun,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
