@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AclEntryAttachment].
 */
@PulumiTagMarker
public class AclEntryAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclEntryAttachmentArgs = AclEntryAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclEntryAttachmentArgsBuilder.() -> Unit) {
        val builder = AclEntryAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AclEntryAttachment {
        val builtJavaResource = com.pulumi.alicloud.ga.AclEntryAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AclEntryAttachment(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Acl entry attachment resource.
 * For information about Global Accelerator (GA) Acl entry attachment and how to use it, see [What is Acl entry attachment](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-addentriestoacl).
 * > **NOTE:** Available since v1.190.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Acl("default", {
 *     aclName: "tf-example-value",
 *     addressIpVersion: "IPv4",
 * });
 * const defaultAclEntryAttachment = new alicloud.ga.AclEntryAttachment("default", {
 *     aclId: _default.id,
 *     entry: "192.168.1.1/32",
 *     entryDescription: "tf-example-value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Acl("default",
 *     acl_name="tf-example-value",
 *     address_ip_version="IPv4")
 * default_acl_entry_attachment = alicloud.ga.AclEntryAttachment("default",
 *     acl_id=default.id,
 *     entry="192.168.1.1/32",
 *     entry_description="tf-example-value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Acl("default", new()
 *     {
 *         AclName = "tf-example-value",
 *         AddressIpVersion = "IPv4",
 *     });
 *     var defaultAclEntryAttachment = new AliCloud.Ga.AclEntryAttachment("default", new()
 *     {
 *         AclId = @default.Id,
 *         Entry = "192.168.1.1/32",
 *         EntryDescription = "tf-example-value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAcl(ctx, "default", &ga.AclArgs{
 * 			AclName:          pulumi.String("tf-example-value"),
 * 			AddressIpVersion: pulumi.String("IPv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewAclEntryAttachment(ctx, "default", &ga.AclEntryAttachmentArgs{
 * 			AclId:            _default.ID(),
 * 			Entry:            pulumi.String("192.168.1.1/32"),
 * 			EntryDescription: pulumi.String("tf-example-value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Acl;
 * import com.pulumi.alicloud.ga.AclArgs;
 * import com.pulumi.alicloud.ga.AclEntryAttachment;
 * import com.pulumi.alicloud.ga.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .aclName("tf-example-value")
 *             .addressIpVersion("IPv4")
 *             .build());
 *         var defaultAclEntryAttachment = new AclEntryAttachment("defaultAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(default_.id())
 *             .entry("192.168.1.1/32")
 *             .entryDescription("tf-example-value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Acl
 *     properties:
 *       aclName: tf-example-value
 *       addressIpVersion: IPv4
 *   defaultAclEntryAttachment:
 *     type: alicloud:ga:AclEntryAttachment
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       entry: 192.168.1.1/32
 *       entryDescription: tf-example-value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Acl entry attachment can be imported using the id.Format to `<acl_id>:<entry>`, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/aclEntryAttachment:AclEntryAttachment example your_acl_id:your_entry
 * ```
 */
public class AclEntryAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.AclEntryAttachment,
) : KotlinCustomResource(javaResource, AclEntryAttachmentMapper) {
    /**
     * The ID of the global acceleration instance.
     */
    public val aclId: Output<String>
        get() = javaResource.aclId().applyValue({ args0 -> args0 })

    /**
     * The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
     */
    public val entry: Output<String>
        get() = javaResource.entry().applyValue({ args0 -> args0 })

    /**
     * The description of the entry. The description must be 1 to 256 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), and underscores (_).
     */
    public val entryDescription: Output<String>?
        get() = javaResource.entryDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the network ACL.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AclEntryAttachmentMapper : ResourceMapper<AclEntryAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.AclEntryAttachment::class == javaResource::class

    override fun map(javaResource: Resource): AclEntryAttachment = AclEntryAttachment(
        javaResource as
            com.pulumi.alicloud.ga.AclEntryAttachment,
    )
}

/**
 * @see [AclEntryAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AclEntryAttachment].
 */
public suspend fun aclEntryAttachment(
    name: String,
    block: suspend AclEntryAttachmentResourceBuilder.() -> Unit,
): AclEntryAttachment {
    val builder = AclEntryAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AclEntryAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aclEntryAttachment(name: String): AclEntryAttachment {
    val builder = AclEntryAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
