@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.AclEntryAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Acl entry attachment resource.
 * For information about Global Accelerator (GA) Acl entry attachment and how to use it, see [What is Acl entry attachment](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-addentriestoacl).
 * > **NOTE:** Available since v1.190.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ga.Acl("default", {
 *     aclName: "tf-example-value",
 *     addressIpVersion: "IPv4",
 * });
 * const defaultAclEntryAttachment = new alicloud.ga.AclEntryAttachment("default", {
 *     aclId: _default.id,
 *     entry: "192.168.1.1/32",
 *     entryDescription: "tf-example-value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ga.Acl("default",
 *     acl_name="tf-example-value",
 *     address_ip_version="IPv4")
 * default_acl_entry_attachment = alicloud.ga.AclEntryAttachment("default",
 *     acl_id=default.id,
 *     entry="192.168.1.1/32",
 *     entry_description="tf-example-value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ga.Acl("default", new()
 *     {
 *         AclName = "tf-example-value",
 *         AddressIpVersion = "IPv4",
 *     });
 *     var defaultAclEntryAttachment = new AliCloud.Ga.AclEntryAttachment("default", new()
 *     {
 *         AclId = @default.Id,
 *         Entry = "192.168.1.1/32",
 *         EntryDescription = "tf-example-value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewAcl(ctx, "default", &ga.AclArgs{
 * 			AclName:          pulumi.String("tf-example-value"),
 * 			AddressIpVersion: pulumi.String("IPv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ga.NewAclEntryAttachment(ctx, "default", &ga.AclEntryAttachmentArgs{
 * 			AclId:            _default.ID(),
 * 			Entry:            pulumi.String("192.168.1.1/32"),
 * 			EntryDescription: pulumi.String("tf-example-value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.Acl;
 * import com.pulumi.alicloud.ga.AclArgs;
 * import com.pulumi.alicloud.ga.AclEntryAttachment;
 * import com.pulumi.alicloud.ga.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .aclName("tf-example-value")
 *             .addressIpVersion("IPv4")
 *             .build());
 *         var defaultAclEntryAttachment = new AclEntryAttachment("defaultAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(default_.id())
 *             .entry("192.168.1.1/32")
 *             .entryDescription("tf-example-value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ga:Acl
 *     properties:
 *       aclName: tf-example-value
 *       addressIpVersion: IPv4
 *   defaultAclEntryAttachment:
 *     type: alicloud:ga:AclEntryAttachment
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       entry: 192.168.1.1/32
 *       entryDescription: tf-example-value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global Accelerator (GA) Acl entry attachment can be imported using the id.Format to `<acl_id>:<entry>`, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/aclEntryAttachment:AclEntryAttachment example your_acl_id:your_entry
 * ```
 * @property aclId The ID of the global acceleration instance.
 * @property entry The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
 * @property entryDescription The description of the entry. The description must be 1 to 256 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), and underscores (_).
 */
public data class AclEntryAttachmentArgs(
    public val aclId: Output<String>? = null,
    public val entry: Output<String>? = null,
    public val entryDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.AclEntryAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.AclEntryAttachmentArgs =
        com.pulumi.alicloud.ga.AclEntryAttachmentArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .entry(entry?.applyValue({ args0 -> args0 }))
            .entryDescription(entryDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclEntryAttachmentArgs].
 */
@PulumiTagMarker
public class AclEntryAttachmentArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var entry: Output<String>? = null

    private var entryDescription: Output<String>? = null

    /**
     * @param value The ID of the global acceleration instance.
     */
    @JvmName("wdfntdmoafucyhsp")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
     */
    @JvmName("ufcnpyrqkkgoxttt")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value The description of the entry. The description must be 1 to 256 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), and underscores (_).
     */
    @JvmName("shtcrucivpbugfkx")
    public suspend fun entryDescription(`value`: Output<String>) {
        this.entryDescription = value
    }

    /**
     * @param value The ID of the global acceleration instance.
     */
    @JvmName("uutdihsuphuadoxy")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
     */
    @JvmName("kjbmmghdsllmlymy")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    /**
     * @param value The description of the entry. The description must be 1 to 256 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), and underscores (_).
     */
    @JvmName("wcjternqrhafhbxb")
    public suspend fun entryDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryDescription = mapped
    }

    internal fun build(): AclEntryAttachmentArgs = AclEntryAttachmentArgs(
        aclId = aclId,
        entry = entry,
        entryDescription = entryDescription,
    )
}
