@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AdditionalCertificate].
 */
@PulumiTagMarker
public class AdditionalCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdditionalCertificateArgs = AdditionalCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdditionalCertificateArgsBuilder.() -> Unit) {
        val builder = AdditionalCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AdditionalCertificate {
        val builtJavaResource = com.pulumi.alicloud.ga.AdditionalCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AdditionalCertificate(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Additional Certificate resource.
 * For information about Global Accelerator (GA) Additional Certificate and how to use it, see [What is Additional Certificate](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-associateadditionalcertificateswithlistener).
 * > **NOTE:** Available since v1.150.0.
 * ## Import
 * Global Accelerator (GA) Additional Certificate can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/additionalCertificate:AdditionalCertificate example <accelerator_id>:<listener_id>:<domain>
 * ```
 */
public class AdditionalCertificate internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.AdditionalCertificate,
) : KotlinCustomResource(javaResource, AdditionalCertificateMapper) {
    /**
     * The ID of the GA instance.
     */
    public val acceleratorId: Output<String>
        get() = javaResource.acceleratorId().applyValue({ args0 -> args0 })

    /**
     * The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
     */
    public val certificateId: Output<String>
        get() = javaResource.certificateId().applyValue({ args0 -> args0 })

    /**
     * The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })
}

public object AdditionalCertificateMapper : ResourceMapper<AdditionalCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.AdditionalCertificate::class == javaResource::class

    override fun map(javaResource: Resource): AdditionalCertificate =
        AdditionalCertificate(javaResource as com.pulumi.alicloud.ga.AdditionalCertificate)
}

/**
 * @see [AdditionalCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdditionalCertificate].
 */
public suspend fun additionalCertificate(
    name: String,
    block: suspend AdditionalCertificateResourceBuilder.() -> Unit,
): AdditionalCertificate {
    val builder = AdditionalCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdditionalCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun additionalCertificate(name: String): AdditionalCertificate {
    val builder = AdditionalCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
