@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.AdditionalCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Additional Certificate resource.
 * For information about Global Accelerator (GA) Additional Certificate and how to use it, see [What is Additional Certificate](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-associateadditionalcertificateswithlistener).
 * > **NOTE:** Available since v1.150.0.
 * ## Import
 * Global Accelerator (GA) Additional Certificate can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/additionalCertificate:AdditionalCertificate example <accelerator_id>:<listener_id>:<domain>
 * ```
 * @property acceleratorId The ID of the GA instance.
 * @property certificateId The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
 * @property domain The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
 * @property listenerId The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
 */
public data class AdditionalCertificateArgs(
    public val acceleratorId: Output<String>? = null,
    public val certificateId: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val listenerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.AdditionalCertificateArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.AdditionalCertificateArgs =
        com.pulumi.alicloud.ga.AdditionalCertificateArgs.builder()
            .acceleratorId(acceleratorId?.applyValue({ args0 -> args0 }))
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdditionalCertificateArgs].
 */
@PulumiTagMarker
public class AdditionalCertificateArgsBuilder internal constructor() {
    private var acceleratorId: Output<String>? = null

    private var certificateId: Output<String>? = null

    private var domain: Output<String>? = null

    private var listenerId: Output<String>? = null

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("wsfggspcqatgiaoo")
    public suspend fun acceleratorId(`value`: Output<String>) {
        this.acceleratorId = value
    }

    /**
     * @param value The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
     */
    @JvmName("rplxqskecpntrdby")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
     */
    @JvmName("jqfpswliyuvafeso")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
     */
    @JvmName("hmhmuqutkcaykhvy")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value The ID of the GA instance.
     */
    @JvmName("wjgyxkjobutvghcu")
    public suspend fun acceleratorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorId = mapped
    }

    /**
     * @param value The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
     */
    @JvmName("divvallorrwtshtm")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
     */
    @JvmName("yakcligejdsrtskf")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
     */
    @JvmName("qnupnsfkwmwwcjst")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    internal fun build(): AdditionalCertificateArgs = AdditionalCertificateArgs(
        acceleratorId = acceleratorId,
        certificateId = certificateId,
        domain = domain,
        listenerId = listenerId,
    )
}
