@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [BandwidthPackage].
 */
@PulumiTagMarker
public class BandwidthPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BandwidthPackageArgs = BandwidthPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BandwidthPackageArgsBuilder.() -> Unit) {
        val builder = BandwidthPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BandwidthPackage {
        val builtJavaResource = com.pulumi.alicloud.ga.BandwidthPackage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BandwidthPackage(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator (GA) Bandwidth Package resource.
 * For information about Global Accelerator (GA) Bandwidth Package and how to use it, see [What is Bandwidth Package](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbandwidthpackage).
 * > **NOTE:** At present, The `alicloud.ga.BandwidthPackage` created with `Subscription` cannot be deleted. you need to wait until the resource is outdated and released automatically.
 * > **NOTE:** Available since v1.112.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ga.BandwidthPackage("example", {
 *     bandwidth: 20,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     duration: "1",
 *     autoPay: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ga.BandwidthPackage("example",
 *     bandwidth=20,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     duration="1",
 *     auto_pay=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ga.BandwidthPackage("example", new()
 *     {
 *         Bandwidth = 20,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         Duration = "1",
 *         AutoPay = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewBandwidthPackage(ctx, "example", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(20),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			Duration:      pulumi.String("1"),
 * 			AutoPay:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BandwidthPackage("example", BandwidthPackageArgs.builder()
 *             .bandwidth(20)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .duration(1)
 *             .autoPay(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ga:BandwidthPackage
 *     properties:
 *       bandwidth: 20
 *       type: Basic
 *       bandwidthType: Basic
 *       duration: 1
 *       autoPay: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Bandwidth Package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/bandwidthPackage:BandwidthPackage example <id>
 * ```
 */
public class BandwidthPackage internal constructor(
    override val javaResource: com.pulumi.alicloud.ga.BandwidthPackage,
) : KotlinCustomResource(javaResource, BandwidthPackageMapper) {
    /**
     * Whether to pay automatically. Valid values:
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
     */
    public val autoRenewDuration: Output<Int>
        get() = javaResource.autoRenewDuration().applyValue({ args0 -> args0 })

    /**
     * Whether use vouchers. Default value: `false`. Valid values:
     */
    public val autoUseCoupon: Output<Boolean>?
        get() = javaResource.autoUseCoupon().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth value of bandwidth packet.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The name of the bandwidth packet.
     */
    public val bandwidthPackageName: Output<String>?
        get() = javaResource.bandwidthPackageName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
     * > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
     */
    public val bandwidthType: Output<String>?
        get() = javaResource.bandwidthType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
     */
    public val billingType: Output<String>?
        get() = javaResource.billingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
     */
    public val cbnGeographicRegionIda: Output<String>
        get() = javaResource.cbnGeographicRegionIda().applyValue({ args0 -> args0 })

    /**
     * Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
     */
    public val cbnGeographicRegionIdb: Output<String>
        get() = javaResource.cbnGeographicRegionIdb().applyValue({ args0 -> args0 })

    /**
     * The description of bandwidth package.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
     */
    public val duration: Output<String>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    public val promotionOptionNo: Output<String>?
        get() = javaResource.promotionOptionNo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
     */
    public val ratio: Output<Int>?
        get() = javaResource.ratio().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to renew a bandwidth packet. automatically or not. Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the Bandwidth Package.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BandwidthPackageMapper : ResourceMapper<BandwidthPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ga.BandwidthPackage::class == javaResource::class

    override fun map(javaResource: Resource): BandwidthPackage = BandwidthPackage(
        javaResource as
            com.pulumi.alicloud.ga.BandwidthPackage,
    )
}

/**
 * @see [BandwidthPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BandwidthPackage].
 */
public suspend fun bandwidthPackage(
    name: String,
    block: suspend BandwidthPackageResourceBuilder.() -> Unit,
): BandwidthPackage {
    val builder = BandwidthPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BandwidthPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bandwidthPackage(name: String): BandwidthPackage {
    val builder = BandwidthPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
