@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin

import com.pulumi.alicloud.ga.BandwidthPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator (GA) Bandwidth Package resource.
 * For information about Global Accelerator (GA) Bandwidth Package and how to use it, see [What is Bandwidth Package](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createbandwidthpackage).
 * > **NOTE:** At present, The `alicloud.ga.BandwidthPackage` created with `Subscription` cannot be deleted. you need to wait until the resource is outdated and released automatically.
 * > **NOTE:** Available since v1.112.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ga.BandwidthPackage("example", {
 *     bandwidth: 20,
 *     type: "Basic",
 *     bandwidthType: "Basic",
 *     duration: "1",
 *     autoPay: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ga.BandwidthPackage("example",
 *     bandwidth=20,
 *     type="Basic",
 *     bandwidth_type="Basic",
 *     duration="1",
 *     auto_pay=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ga.BandwidthPackage("example", new()
 *     {
 *         Bandwidth = 20,
 *         Type = "Basic",
 *         BandwidthType = "Basic",
 *         Duration = "1",
 *         AutoPay = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ga"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ga.NewBandwidthPackage(ctx, "example", &ga.BandwidthPackageArgs{
 * 			Bandwidth:     pulumi.Int(20),
 * 			Type:          pulumi.String("Basic"),
 * 			BandwidthType: pulumi.String("Basic"),
 * 			Duration:      pulumi.String("1"),
 * 			AutoPay:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ga.BandwidthPackage;
 * import com.pulumi.alicloud.ga.BandwidthPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BandwidthPackage("example", BandwidthPackageArgs.builder()
 *             .bandwidth(20)
 *             .type("Basic")
 *             .bandwidthType("Basic")
 *             .duration(1)
 *             .autoPay(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ga:BandwidthPackage
 *     properties:
 *       bandwidth: 20
 *       type: Basic
 *       bandwidthType: Basic
 *       duration: 1
 *       autoPay: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ga Bandwidth Package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ga/bandwidthPackage:BandwidthPackage example <id>
 * ```
 * @property autoPay Whether to pay automatically. Valid values:
 * @property autoRenewDuration Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
 * @property autoUseCoupon Whether use vouchers. Default value: `false`. Valid values:
 * @property bandwidth The bandwidth value of bandwidth packet.
 * @property bandwidthPackageName The name of the bandwidth packet.
 * @property bandwidthType The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
 * > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
 * @property billingType The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
 * @property cbnGeographicRegionIda Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
 * @property cbnGeographicRegionIdb Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
 * @property description The description of bandwidth package.
 * @property duration The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
 * @property paymentType The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
 * @property promotionOptionNo The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
 * @property ratio The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
 * @property renewalStatus Whether to renew a bandwidth packet. automatically or not. Valid values:
 * - `AutoRenewal`: Enable auto renewal.
 * - `Normal`: Disable auto renewal.
 * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
 * @property resourceGroupId The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property tags A mapping of tags to assign to the resource.
 * @property type The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
 */
public data class BandwidthPackageArgs(
    public val autoPay: Output<Boolean>? = null,
    public val autoRenewDuration: Output<Int>? = null,
    public val autoUseCoupon: Output<Boolean>? = null,
    public val bandwidth: Output<Int>? = null,
    public val bandwidthPackageName: Output<String>? = null,
    public val bandwidthType: Output<String>? = null,
    public val billingType: Output<String>? = null,
    public val cbnGeographicRegionIda: Output<String>? = null,
    public val cbnGeographicRegionIdb: Output<String>? = null,
    public val description: Output<String>? = null,
    public val duration: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val promotionOptionNo: Output<String>? = null,
    public val ratio: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ga.BandwidthPackageArgs> {
    override fun toJava(): com.pulumi.alicloud.ga.BandwidthPackageArgs =
        com.pulumi.alicloud.ga.BandwidthPackageArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoRenewDuration(autoRenewDuration?.applyValue({ args0 -> args0 }))
            .autoUseCoupon(autoUseCoupon?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .bandwidthPackageName(bandwidthPackageName?.applyValue({ args0 -> args0 }))
            .bandwidthType(bandwidthType?.applyValue({ args0 -> args0 }))
            .billingType(billingType?.applyValue({ args0 -> args0 }))
            .cbnGeographicRegionIda(cbnGeographicRegionIda?.applyValue({ args0 -> args0 }))
            .cbnGeographicRegionIdb(cbnGeographicRegionIdb?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .promotionOptionNo(promotionOptionNo?.applyValue({ args0 -> args0 }))
            .ratio(ratio?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BandwidthPackageArgs].
 */
@PulumiTagMarker
public class BandwidthPackageArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var autoRenewDuration: Output<Int>? = null

    private var autoUseCoupon: Output<Boolean>? = null

    private var bandwidth: Output<Int>? = null

    private var bandwidthPackageName: Output<String>? = null

    private var bandwidthType: Output<String>? = null

    private var billingType: Output<String>? = null

    private var cbnGeographicRegionIda: Output<String>? = null

    private var cbnGeographicRegionIdb: Output<String>? = null

    private var description: Output<String>? = null

    private var duration: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var promotionOptionNo: Output<String>? = null

    private var ratio: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Whether to pay automatically. Valid values:
     */
    @JvmName("yedojijxcvxrashm")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
     */
    @JvmName("cygjaeabjfrpbver")
    public suspend fun autoRenewDuration(`value`: Output<Int>) {
        this.autoRenewDuration = value
    }

    /**
     * @param value Whether use vouchers. Default value: `false`. Valid values:
     */
    @JvmName("caqyvtoowtyhuoha")
    public suspend fun autoUseCoupon(`value`: Output<Boolean>) {
        this.autoUseCoupon = value
    }

    /**
     * @param value The bandwidth value of bandwidth packet.
     */
    @JvmName("bkgnvlbtpqupdxat")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The name of the bandwidth packet.
     */
    @JvmName("buvcpkkrjgwbjvgg")
    public suspend fun bandwidthPackageName(`value`: Output<String>) {
        this.bandwidthPackageName = value
    }

    /**
     * @param value The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
     * > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
     */
    @JvmName("sdhnwifrebdiowqf")
    public suspend fun bandwidthType(`value`: Output<String>) {
        this.bandwidthType = value
    }

    /**
     * @param value The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
     */
    @JvmName("itrsdumkrudnyohu")
    public suspend fun billingType(`value`: Output<String>) {
        this.billingType = value
    }

    /**
     * @param value Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
     */
    @JvmName("bslddgxfnwmbdapo")
    public suspend fun cbnGeographicRegionIda(`value`: Output<String>) {
        this.cbnGeographicRegionIda = value
    }

    /**
     * @param value Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
     */
    @JvmName("ymhmupumdwywxban")
    public suspend fun cbnGeographicRegionIdb(`value`: Output<String>) {
        this.cbnGeographicRegionIdb = value
    }

    /**
     * @param value The description of bandwidth package.
     */
    @JvmName("tpaqmurlrydnovhm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
     */
    @JvmName("orvhnimybjqcbkgb")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("ffmdabtcxjwjfvmf")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    @JvmName("nqcdceawhlpebjab")
    public suspend fun promotionOptionNo(`value`: Output<String>) {
        this.promotionOptionNo = value
    }

    /**
     * @param value The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
     */
    @JvmName("qvyifbclylyrulrr")
    public suspend fun ratio(`value`: Output<Int>) {
        this.ratio = value
    }

    /**
     * @param value Whether to renew a bandwidth packet. automatically or not. Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    @JvmName("gwikbniedighsdrm")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("wuauohrbchkapsqd")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("trfpmnonvapwfxiw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
     */
    @JvmName("pjumlhxybedgcmil")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Whether to pay automatically. Valid values:
     */
    @JvmName("tuswixivicxrtuhh")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Auto renewal period of a bandwidth packet, in the unit of month. Valid values: `1` to `12`.
     */
    @JvmName("fqatbxbrbkhulqwd")
    public suspend fun autoRenewDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewDuration = mapped
    }

    /**
     * @param value Whether use vouchers. Default value: `false`. Valid values:
     */
    @JvmName("xhuxkbabqeefkpfg")
    public suspend fun autoUseCoupon(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUseCoupon = mapped
    }

    /**
     * @param value The bandwidth value of bandwidth packet.
     */
    @JvmName("mstxskybsoaygysr")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The name of the bandwidth packet.
     */
    @JvmName("rqksijunhetnsoib")
    public suspend fun bandwidthPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthPackageName = mapped
    }

    /**
     * @param value The bandwidth type of the bandwidth. Valid values: `Advanced`, `Basic`, `Enhanced`. If `type` is set to `Basic`, this parameter is required.
     * > **NOTE:** At present, only basic can be configured to enhanced, but not enhanced and advanced to other types of accelerated bandwidth.
     */
    @JvmName("fsgapphkpuitmahc")
    public suspend fun bandwidthType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthType = mapped
    }

    /**
     * @param value The billing type. Valid values: `PayBy95`, `PayByTraffic`. **NOTE:** `billing_type` is valid only when `payment_type` is set to `PayAsYouGo`.
     */
    @JvmName("jclvcfnmeopslnvo")
    public suspend fun billingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value Interworking area A of cross domain acceleration package. Only international stations support returning this parameter. Default value: `China-mainland`.
     */
    @JvmName("sbjjuivtfgwkojno")
    public suspend fun cbnGeographicRegionIda(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cbnGeographicRegionIda = mapped
    }

    /**
     * @param value Interworking area B of cross domain acceleration package. Only international stations support returning this parameter. Default value: `Global`.
     */
    @JvmName("pydxxnidtnuhocoy")
    public suspend fun cbnGeographicRegionIdb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cbnGeographicRegionIdb = mapped
    }

    /**
     * @param value The description of bandwidth package.
     */
    @JvmName("pcrexijyfvnarkas")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The subscription duration. **NOTE:** The ForceNew attribute has be removed from version 1.148.0. If `payment_type` is set to `Subscription`, this parameter is required.
     */
    @JvmName("ciytmdprtjsgmvkj")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The payment type of the bandwidth. Default value: `Subscription`. Valid values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("symxisaniesgskyg")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The code of the coupon. **NOTE:** The `promotion_option_no` takes effect only for accounts registered on the international site (alibabacloud.com).
     */
    @JvmName("tpernjswxseokshc")
    public suspend fun promotionOptionNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionOptionNo = mapped
    }

    /**
     * @param value The minimum percentage for the pay-by-95th-percentile metering method. Valid values: `30` to `100`. **NOTE:** `ratio` is valid only when `billing_type` is set to `PayBy95`.
     */
    @JvmName("nabqwlnpxhnxnikn")
    public suspend fun ratio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ratio = mapped
    }

    /**
     * @param value Whether to renew a bandwidth packet. automatically or not. Valid values:
     * - `AutoRenewal`: Enable auto renewal.
     * - `Normal`: Disable auto renewal.
     * - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
     */
    @JvmName("tscmseiexoeyltlt")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("hnivsgvumhnjlxcy")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("tqjwufyhhpumpxnq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("mywkgvbfiufxkpdm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the bandwidth packet. China station only supports return to basic. Valid values: `Basic`, `CrossDomain`.
     */
    @JvmName("bvoeocjxmlqaffnf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BandwidthPackageArgs = BandwidthPackageArgs(
        autoPay = autoPay,
        autoRenewDuration = autoRenewDuration,
        autoUseCoupon = autoUseCoupon,
        bandwidth = bandwidth,
        bandwidthPackageName = bandwidthPackageName,
        bandwidthType = bandwidthType,
        billingType = billingType,
        cbnGeographicRegionIda = cbnGeographicRegionIda,
        cbnGeographicRegionIdb = cbnGeographicRegionIdb,
        description = description,
        duration = duration,
        paymentType = paymentType,
        promotionOptionNo = promotionOptionNo,
        ratio = ratio,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        tags = tags,
        type = type,
    )
}
